package physx.character;


public class JavaControllerFilterCallback extends PxControllerFilterCallback {

    public static JavaControllerFilterCallback wrapPointer(long address) {
        return address != 0L ? new JavaControllerFilterCallback(address) : null;
    }
    
    protected JavaControllerFilterCallback(long address) {
        super(address);
    }

    protected JavaControllerFilterCallback() {
        address = _JavaControllerFilterCallback();
    }
    private native long _JavaControllerFilterCallback();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private boolean _filter(long a, long b) {
        return filter(PxController.wrapPointer(a), PxController.wrapPointer(b));
    }

    /**
     * @param a WebIDL type: {@link PxController} [Const, Ref]
     * @param b WebIDL type: {@link PxController} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean filter(PxController a, PxController b) {
        return false;
    }

}
