package physx.support;

import physx.NativeObject;

public class PxPvdTransport extends NativeObject {

    protected PxPvdTransport() { }

    public static PxPvdTransport wrapPointer(long address) {
        return address != 0L ? new PxPvdTransport(address) : null;
    }
    
    protected PxPvdTransport(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean connect() {
        checkNotNull();
        return _connect(address);
    }
    private static native boolean _connect(long address);

    public void disconnect() {
        checkNotNull();
        _disconnect(address);
    }
    private static native void _disconnect(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isConnected() {
        checkNotNull();
        return _isConnected(address);
    }
    private static native boolean _isConnected(long address);

}
