package physx.physics;

import physx.NativeObject;

public class PxBatchQueryMemory extends NativeObject {

    protected PxBatchQueryMemory() { }

    public static PxBatchQueryMemory wrapPointer(long address) {
        return address != 0L ? new PxBatchQueryMemory(address) : null;
    }
    
    protected PxBatchQueryMemory(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxRaycastQueryResult}
     */
    public PxRaycastQueryResult getUserRaycastResultBuffer() {
        checkNotNull();
        return PxRaycastQueryResult.wrapPointer(_getUserRaycastResultBuffer(address));
    }
    private static native long _getUserRaycastResultBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxRaycastQueryResult}
     */
    public void setUserRaycastResultBuffer(PxRaycastQueryResult value) {
        checkNotNull();
        _setUserRaycastResultBuffer(address, value.getAddress());
    }
    private static native void _setUserRaycastResultBuffer(long address, long value);

    /**
     * @return WebIDL type: {@link PxRaycastHit}
     */
    public PxRaycastHit getUserRaycastTouchBuffer() {
        checkNotNull();
        return PxRaycastHit.wrapPointer(_getUserRaycastTouchBuffer(address));
    }
    private static native long _getUserRaycastTouchBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxRaycastHit}
     */
    public void setUserRaycastTouchBuffer(PxRaycastHit value) {
        checkNotNull();
        _setUserRaycastTouchBuffer(address, value.getAddress());
    }
    private static native void _setUserRaycastTouchBuffer(long address, long value);

    /**
     * @return WebIDL type: {@link PxSweepQueryResult}
     */
    public PxSweepQueryResult getUserSweepResultBuffer() {
        checkNotNull();
        return PxSweepQueryResult.wrapPointer(_getUserSweepResultBuffer(address));
    }
    private static native long _getUserSweepResultBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxSweepQueryResult}
     */
    public void setUserSweepResultBuffer(PxSweepQueryResult value) {
        checkNotNull();
        _setUserSweepResultBuffer(address, value.getAddress());
    }
    private static native void _setUserSweepResultBuffer(long address, long value);

    /**
     * @return WebIDL type: {@link PxSweepHit}
     */
    public PxSweepHit getUserSweepTouchBuffer() {
        checkNotNull();
        return PxSweepHit.wrapPointer(_getUserSweepTouchBuffer(address));
    }
    private static native long _getUserSweepTouchBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxSweepHit}
     */
    public void setUserSweepTouchBuffer(PxSweepHit value) {
        checkNotNull();
        _setUserSweepTouchBuffer(address, value.getAddress());
    }
    private static native void _setUserSweepTouchBuffer(long address, long value);

    /**
     * @return WebIDL type: {@link PxOverlapQueryResult}
     */
    public PxOverlapQueryResult getUserOverlapResultBuffer() {
        checkNotNull();
        return PxOverlapQueryResult.wrapPointer(_getUserOverlapResultBuffer(address));
    }
    private static native long _getUserOverlapResultBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxOverlapQueryResult}
     */
    public void setUserOverlapResultBuffer(PxOverlapQueryResult value) {
        checkNotNull();
        _setUserOverlapResultBuffer(address, value.getAddress());
    }
    private static native void _setUserOverlapResultBuffer(long address, long value);

    /**
     * @return WebIDL type: {@link PxOverlapHit}
     */
    public PxOverlapHit getUserOverlapTouchBuffer() {
        checkNotNull();
        return PxOverlapHit.wrapPointer(_getUserOverlapTouchBuffer(address));
    }
    private static native long _getUserOverlapTouchBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxOverlapHit}
     */
    public void setUserOverlapTouchBuffer(PxOverlapHit value) {
        checkNotNull();
        _setUserOverlapTouchBuffer(address, value.getAddress());
    }
    private static native void _setUserOverlapTouchBuffer(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getRaycastTouchBufferSize() {
        checkNotNull();
        return _getRaycastTouchBufferSize(address);
    }
    private static native int _getRaycastTouchBufferSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setRaycastTouchBufferSize(int value) {
        checkNotNull();
        _setRaycastTouchBufferSize(address, value);
    }
    private static native void _setRaycastTouchBufferSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSweepTouchBufferSize() {
        checkNotNull();
        return _getSweepTouchBufferSize(address);
    }
    private static native int _getSweepTouchBufferSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setSweepTouchBufferSize(int value) {
        checkNotNull();
        _setSweepTouchBufferSize(address, value);
    }
    private static native void _setSweepTouchBufferSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getOverlapTouchBufferSize() {
        checkNotNull();
        return _getOverlapTouchBufferSize(address);
    }
    private static native int _getOverlapTouchBufferSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setOverlapTouchBufferSize(int value) {
        checkNotNull();
        _setOverlapTouchBufferSize(address, value);
    }
    private static native void _setOverlapTouchBufferSize(long address, int value);

}
