package physx.physics;

import physx.common.PxBase;
import physx.geomutils.PxBVHStructure;

public class PxAggregate extends PxBase {

    protected PxAggregate() { }

    public static PxAggregate wrapPointer(long address) {
        return address != 0L ? new PxAggregate(address) : null;
    }
    
    protected PxAggregate(long address) {
        super(address);
    }

    // Functions

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean addActor(PxActor actor) {
        checkNotNull();
        return _addActor(address, actor.getAddress());
    }
    private static native boolean _addActor(long address, long actor);

    /**
     * @param actor        WebIDL type: {@link PxActor} [Ref]
     * @param bvhStructure WebIDL type: {@link PxBVHStructure} [Const]
     * @return WebIDL type: boolean
     */
    public boolean addActor(PxActor actor, PxBVHStructure bvhStructure) {
        checkNotNull();
        return _addActor(address, actor.getAddress(), bvhStructure.getAddress());
    }
    private static native boolean _addActor(long address, long actor, long bvhStructure);

    /**
     * @param actor WebIDL type: {@link PxActor} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean removeActor(PxActor actor) {
        checkNotNull();
        return _removeActor(address, actor.getAddress());
    }
    private static native boolean _removeActor(long address, long actor);

    /**
     * @param articulation WebIDL type: {@link PxArticulationBase} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean addArticulation(PxArticulationBase articulation) {
        checkNotNull();
        return _addArticulation(address, articulation.getAddress());
    }
    private static native boolean _addArticulation(long address, long articulation);

    /**
     * @param articulation WebIDL type: {@link PxArticulationBase} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean removeArticulation(PxArticulationBase articulation) {
        checkNotNull();
        return _removeArticulation(address, articulation.getAddress());
    }
    private static native boolean _removeArticulation(long address, long articulation);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbActors() {
        checkNotNull();
        return _getNbActors(address);
    }
    private static native int _getNbActors(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbActors() {
        checkNotNull();
        return _getMaxNbActors(address);
    }
    private static native int _getMaxNbActors(long address);

    /**
     * @return WebIDL type: {@link PxScene}
     */
    public PxScene getScene() {
        checkNotNull();
        return PxScene.wrapPointer(_getScene(address));
    }
    private static native long _getScene(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getSelfCollision() {
        checkNotNull();
        return _getSelfCollision(address);
    }
    private static native boolean _getSelfCollision(long address);

}
