package physx.geomutils;

import physx.NativeObject;

public class PxMeshFlags extends NativeObject {

    protected PxMeshFlags() { }

    public static PxMeshFlags wrapPointer(long address) {
        return address != 0L ? new PxMeshFlags(address) : null;
    }
    
    protected PxMeshFlags(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: octet
     * @return Stack allocated object of PxMeshFlags
     */
    public static PxMeshFlags createAt(long address, byte flags) {
        __placement_new_PxMeshFlags(address, flags);
        PxMeshFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: octet
     * @return Stack allocated object of PxMeshFlags
     */
    public static <T> PxMeshFlags createAt(T allocator, Allocator<T> allocate, byte flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxMeshFlags(address, flags);
        PxMeshFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxMeshFlags(long address, byte flags);

    // Constructors

    /**
     * @param flags WebIDL type: octet
     */
    public PxMeshFlags(byte flags) {
        address = _PxMeshFlags(flags);
    }
    private static native long _PxMeshFlags(byte flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxMeshFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(int flag) {
        checkNotNull();
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxMeshFlagEnum} [enum]
     */
    public void set(int flag) {
        checkNotNull();
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxMeshFlagEnum} [enum]
     */
    public void clear(int flag) {
        checkNotNull();
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
