package physx.extensions;

import physx.NativeObject;
import physx.common.PxCollection;
import physx.common.PxInputData;
import physx.common.PxOutputStream;
import physx.cooking.PxCooking;
import physx.physics.PxPhysics;

public class PxSerialization extends NativeObject {

    protected PxSerialization() { }

    public static PxSerialization wrapPointer(long address) {
        return address != 0L ? new PxSerialization(address) : null;
    }
    
    protected PxSerialization(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param collection WebIDL type: {@link PxCollection} [Ref]
     * @param sr         WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean isSerializable(PxCollection collection, PxSerializationRegistry sr) {
        return _isSerializable(collection.getAddress(), sr.getAddress());
    }
    private static native boolean _isSerializable(long collection, long sr);

    /**
     * @param collection         WebIDL type: {@link PxCollection} [Ref]
     * @param sr                 WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @param externalReferences WebIDL type: {@link PxCollection} [Const]
     * @return WebIDL type: boolean
     */
    public static boolean isSerializable(PxCollection collection, PxSerializationRegistry sr, PxCollection externalReferences) {
        return _isSerializable(collection.getAddress(), sr.getAddress(), externalReferences.getAddress());
    }
    private static native boolean _isSerializable(long collection, long sr, long externalReferences);

    /**
     * @param collection WebIDL type: {@link PxCollection} [Ref]
     * @param sr         WebIDL type: {@link PxSerializationRegistry} [Ref]
     */
    public static void complete(PxCollection collection, PxSerializationRegistry sr) {
        _complete(collection.getAddress(), sr.getAddress());
    }
    private static native void _complete(long collection, long sr);

    /**
     * @param collection WebIDL type: {@link PxCollection} [Ref]
     * @param sr         WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @param exceptFor  WebIDL type: {@link PxCollection} [Const]
     */
    public static void complete(PxCollection collection, PxSerializationRegistry sr, PxCollection exceptFor) {
        _complete(collection.getAddress(), sr.getAddress(), exceptFor.getAddress());
    }
    private static native void _complete(long collection, long sr, long exceptFor);

    /**
     * @param collection   WebIDL type: {@link PxCollection} [Ref]
     * @param sr           WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @param exceptFor    WebIDL type: {@link PxCollection} [Const]
     * @param followJoints WebIDL type: boolean
     */
    public static void complete(PxCollection collection, PxSerializationRegistry sr, PxCollection exceptFor, boolean followJoints) {
        _complete(collection.getAddress(), sr.getAddress(), exceptFor.getAddress(), followJoints);
    }
    private static native void _complete(long collection, long sr, long exceptFor, boolean followJoints);

    /**
     * @param collection WebIDL type: {@link PxCollection} [Ref]
     * @param base       WebIDL type: unsigned long long
     */
    public static void createSerialObjectIds(PxCollection collection, long base) {
        _createSerialObjectIds(collection.getAddress(), base);
    }
    private static native void _createSerialObjectIds(long collection, long base);

    /**
     * @param inputData WebIDL type: {@link PxInputData} [Ref]
     * @param cooking   WebIDL type: {@link PxCooking} [Ref]
     * @param sr        WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @return WebIDL type: {@link PxCollection}
     */
    public static PxCollection createCollectionFromXml(PxInputData inputData, PxCooking cooking, PxSerializationRegistry sr) {
        return PxCollection.wrapPointer(_createCollectionFromXml(inputData.getAddress(), cooking.getAddress(), sr.getAddress()));
    }
    private static native long _createCollectionFromXml(long inputData, long cooking, long sr);

    /**
     * @param inputData    WebIDL type: {@link PxInputData} [Ref]
     * @param cooking      WebIDL type: {@link PxCooking} [Ref]
     * @param sr           WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @param externalRefs WebIDL type: {@link PxCollection} [Const]
     * @return WebIDL type: {@link PxCollection}
     */
    public static PxCollection createCollectionFromXml(PxInputData inputData, PxCooking cooking, PxSerializationRegistry sr, PxCollection externalRefs) {
        return PxCollection.wrapPointer(_createCollectionFromXml(inputData.getAddress(), cooking.getAddress(), sr.getAddress(), externalRefs.getAddress()));
    }
    private static native long _createCollectionFromXml(long inputData, long cooking, long sr, long externalRefs);

    /**
     * @param memBlock WebIDL type: VoidPtr
     * @param sr       WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @return WebIDL type: {@link PxCollection}
     */
    public static PxCollection createCollectionFromBinary(NativeObject memBlock, PxSerializationRegistry sr) {
        return PxCollection.wrapPointer(_createCollectionFromBinary(memBlock.getAddress(), sr.getAddress()));
    }
    private static native long _createCollectionFromBinary(long memBlock, long sr);

    /**
     * @param memBlock     WebIDL type: VoidPtr
     * @param sr           WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @param externalRefs WebIDL type: {@link PxCollection} [Const]
     * @return WebIDL type: {@link PxCollection}
     */
    public static PxCollection createCollectionFromBinary(NativeObject memBlock, PxSerializationRegistry sr, PxCollection externalRefs) {
        return PxCollection.wrapPointer(_createCollectionFromBinary(memBlock.getAddress(), sr.getAddress(), externalRefs.getAddress()));
    }
    private static native long _createCollectionFromBinary(long memBlock, long sr, long externalRefs);

    /**
     * @param outputStream WebIDL type: {@link PxOutputStream} [Ref]
     * @param collection   WebIDL type: {@link PxCollection} [Ref]
     * @param sr           WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean serializeCollectionToXml(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr) {
        return _serializeCollectionToXml(outputStream.getAddress(), collection.getAddress(), sr.getAddress());
    }
    private static native boolean _serializeCollectionToXml(long outputStream, long collection, long sr);

    /**
     * @param outputStream WebIDL type: {@link PxOutputStream} [Ref]
     * @param collection   WebIDL type: {@link PxCollection} [Ref]
     * @param sr           WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @param cooking      WebIDL type: {@link PxCooking}
     * @return WebIDL type: boolean
     */
    public static boolean serializeCollectionToXml(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr, PxCooking cooking) {
        return _serializeCollectionToXml(outputStream.getAddress(), collection.getAddress(), sr.getAddress(), cooking.getAddress());
    }
    private static native boolean _serializeCollectionToXml(long outputStream, long collection, long sr, long cooking);

    /**
     * @param outputStream WebIDL type: {@link PxOutputStream} [Ref]
     * @param collection   WebIDL type: {@link PxCollection} [Ref]
     * @param sr           WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @param cooking      WebIDL type: {@link PxCooking}
     * @param externalRefs WebIDL type: {@link PxCollection} [Const]
     * @return WebIDL type: boolean
     */
    public static boolean serializeCollectionToXml(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr, PxCooking cooking, PxCollection externalRefs) {
        return _serializeCollectionToXml(outputStream.getAddress(), collection.getAddress(), sr.getAddress(), cooking.getAddress(), externalRefs.getAddress());
    }
    private static native boolean _serializeCollectionToXml(long outputStream, long collection, long sr, long cooking, long externalRefs);

    /**
     * @param outputStream WebIDL type: {@link PxOutputStream} [Ref]
     * @param collection   WebIDL type: {@link PxCollection} [Ref]
     * @param sr           WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean serializeCollectionToBinary(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr) {
        return _serializeCollectionToBinary(outputStream.getAddress(), collection.getAddress(), sr.getAddress());
    }
    private static native boolean _serializeCollectionToBinary(long outputStream, long collection, long sr);

    /**
     * @param outputStream WebIDL type: {@link PxOutputStream} [Ref]
     * @param collection   WebIDL type: {@link PxCollection} [Ref]
     * @param sr           WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @param externalRefs WebIDL type: {@link PxCollection} [Const]
     * @return WebIDL type: boolean
     */
    public static boolean serializeCollectionToBinary(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr, PxCollection externalRefs) {
        return _serializeCollectionToBinary(outputStream.getAddress(), collection.getAddress(), sr.getAddress(), externalRefs.getAddress());
    }
    private static native boolean _serializeCollectionToBinary(long outputStream, long collection, long sr, long externalRefs);

    /**
     * @param outputStream WebIDL type: {@link PxOutputStream} [Ref]
     * @param collection   WebIDL type: {@link PxCollection} [Ref]
     * @param sr           WebIDL type: {@link PxSerializationRegistry} [Ref]
     * @param externalRefs WebIDL type: {@link PxCollection} [Const]
     * @param exportNames  WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public static boolean serializeCollectionToBinary(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr, PxCollection externalRefs, boolean exportNames) {
        return _serializeCollectionToBinary(outputStream.getAddress(), collection.getAddress(), sr.getAddress(), externalRefs.getAddress(), exportNames);
    }
    private static native boolean _serializeCollectionToBinary(long outputStream, long collection, long sr, long externalRefs, boolean exportNames);

    /**
     * @param physics WebIDL type: {@link PxPhysics} [Ref]
     * @return WebIDL type: {@link PxSerializationRegistry}
     */
    public static PxSerializationRegistry createSerializationRegistry(PxPhysics physics) {
        return PxSerializationRegistry.wrapPointer(_createSerializationRegistry(physics.getAddress()));
    }
    private static native long _createSerializationRegistry(long physics);

}
