package physx.character;

import physx.physics.PxRigidActor;
import physx.physics.PxShape;

public class PxControllerShapeHit extends PxControllerHit {

    protected PxControllerShapeHit() { }

    public static PxControllerShapeHit wrapPointer(long address) {
        return address != 0L ? new PxControllerShapeHit(address) : null;
    }
    
    protected PxControllerShapeHit(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getShape() {
        checkNotNull();
        return PxShape.wrapPointer(_getShape(address));
    }
    private static native long _getShape(long address);

    /**
     * @param value WebIDL type: {@link PxShape}
     */
    public void setShape(PxShape value) {
        checkNotNull();
        _setShape(address, value.getAddress());
    }
    private static native void _setShape(long address, long value);

    /**
     * @return WebIDL type: {@link PxRigidActor}
     */
    public PxRigidActor getActor() {
        checkNotNull();
        return PxRigidActor.wrapPointer(_getActor(address));
    }
    private static native long _getActor(long address);

    /**
     * @param value WebIDL type: {@link PxRigidActor}
     */
    public void setActor(PxRigidActor value) {
        checkNotNull();
        _setActor(address, value.getAddress());
    }
    private static native void _setActor(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTriangleIndex() {
        checkNotNull();
        return _getTriangleIndex(address);
    }
    private static native int _getTriangleIndex(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setTriangleIndex(int value) {
        checkNotNull();
        _setTriangleIndex(address, value);
    }
    private static native void _setTriangleIndex(long address, int value);

}
