package physx.character;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxControllerHit extends NativeObject {

    protected PxControllerHit() { }

    public static PxControllerHit wrapPointer(long address) {
        return address != 0L ? new PxControllerHit(address) : null;
    }
    
    protected PxControllerHit(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxController}
     */
    public PxController getController() {
        checkNotNull();
        return PxController.wrapPointer(_getController(address));
    }
    private static native long _getController(long address);

    /**
     * @param value WebIDL type: {@link PxController}
     */
    public void setController(PxController value) {
        checkNotNull();
        _setController(address, value.getAddress());
    }
    private static native void _setController(long address, long value);

    /**
     * @return WebIDL type: {@link PxExtendedVec3} [Value]
     */
    public PxExtendedVec3 getWorldPos() {
        checkNotNull();
        return PxExtendedVec3.wrapPointer(_getWorldPos(address));
    }
    private static native long _getWorldPos(long address);

    /**
     * @param value WebIDL type: {@link PxExtendedVec3} [Value]
     */
    public void setWorldPos(PxExtendedVec3 value) {
        checkNotNull();
        _setWorldPos(address, value.getAddress());
    }
    private static native void _setWorldPos(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getWorldNormal() {
        checkNotNull();
        return PxVec3.wrapPointer(_getWorldNormal(address));
    }
    private static native long _getWorldNormal(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setWorldNormal(PxVec3 value) {
        checkNotNull();
        _setWorldNormal(address, value.getAddress());
    }
    private static native void _setWorldNormal(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getDir() {
        checkNotNull();
        return PxVec3.wrapPointer(_getDir(address));
    }
    private static native long _getDir(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setDir(PxVec3 value) {
        checkNotNull();
        _setDir(address, value.getAddress());
    }
    private static native void _setDir(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getLength() {
        checkNotNull();
        return _getLength(address);
    }
    private static native float _getLength(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLength(float value) {
        checkNotNull();
        _setLength(address, value);
    }
    private static native void _setLength(long address, float value);

}
