package physx.vehicle;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxActor;
import physx.physics.PxMaterial;
import physx.physics.PxShape;

public class PxWheelQueryResult extends NativeObject {

    public static PxWheelQueryResult wrapPointer(long address) {
        return address != 0L ? new PxWheelQueryResult(address) : null;
    }
    
    protected PxWheelQueryResult(long address) {
        super(address);
    }

    // Constructors

    public PxWheelQueryResult() {
        address = _PxWheelQueryResult();
    }
    private static native long _PxWheelQueryResult();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getSuspLineStart() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_getSuspLineStart(address));
    }
    private static native long _getSuspLineStart(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setSuspLineStart(PxVec3 value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSuspLineStart(address, value.getAddress());
    }
    private static native void _setSuspLineStart(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getSuspLineDir() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_getSuspLineDir(address));
    }
    private static native long _getSuspLineDir(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setSuspLineDir(PxVec3 value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSuspLineDir(address, value.getAddress());
    }
    private static native void _setSuspLineDir(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getSuspLineLength() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getSuspLineLength(address);
    }
    private static native float _getSuspLineLength(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setSuspLineLength(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSuspLineLength(address, value);
    }
    private static native void _setSuspLineLength(long address, float value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getIsInAir() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getIsInAir(address);
    }
    private static native boolean _getIsInAir(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setIsInAir(boolean value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setIsInAir(address, value);
    }
    private static native void _setIsInAir(long address, boolean value);

    /**
     * @return WebIDL type: {@link PxActor}
     */
    public PxActor getTireContactActor() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxActor.wrapPointer(_getTireContactActor(address));
    }
    private static native long _getTireContactActor(long address);

    /**
     * @param value WebIDL type: {@link PxActor}
     */
    public void setTireContactActor(PxActor value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTireContactActor(address, value.getAddress());
    }
    private static native void _setTireContactActor(long address, long value);

    /**
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getTireContactShape() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxShape.wrapPointer(_getTireContactShape(address));
    }
    private static native long _getTireContactShape(long address);

    /**
     * @param value WebIDL type: {@link PxShape}
     */
    public void setTireContactShape(PxShape value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTireContactShape(address, value.getAddress());
    }
    private static native void _setTireContactShape(long address, long value);

    /**
     * @return WebIDL type: {@link PxMaterial} [Const]
     */
    public PxMaterial getTireSurfaceMaterial() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxMaterial.wrapPointer(_getTireSurfaceMaterial(address));
    }
    private static native long _getTireSurfaceMaterial(long address);

    /**
     * @param value WebIDL type: {@link PxMaterial} [Const]
     */
    public void setTireSurfaceMaterial(PxMaterial value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTireSurfaceMaterial(address, value.getAddress());
    }
    private static native void _setTireSurfaceMaterial(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTireSurfaceType() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getTireSurfaceType(address);
    }
    private static native int _getTireSurfaceType(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setTireSurfaceType(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTireSurfaceType(address, value);
    }
    private static native void _setTireSurfaceType(long address, int value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTireContactPoint() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_getTireContactPoint(address));
    }
    private static native long _getTireContactPoint(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTireContactPoint(PxVec3 value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTireContactPoint(address, value.getAddress());
    }
    private static native void _setTireContactPoint(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTireContactNormal() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_getTireContactNormal(address));
    }
    private static native long _getTireContactNormal(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTireContactNormal(PxVec3 value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTireContactNormal(address, value.getAddress());
    }
    private static native void _setTireContactNormal(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getTireFriction() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getTireFriction(address);
    }
    private static native float _getTireFriction(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setTireFriction(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTireFriction(address, value);
    }
    private static native void _setTireFriction(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getSuspJounce() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getSuspJounce(address);
    }
    private static native float _getSuspJounce(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setSuspJounce(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSuspJounce(address, value);
    }
    private static native void _setSuspJounce(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getSuspSpringForce() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getSuspSpringForce(address);
    }
    private static native float _getSuspSpringForce(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setSuspSpringForce(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSuspSpringForce(address, value);
    }
    private static native void _setSuspSpringForce(long address, float value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTireLongitudinalDir() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_getTireLongitudinalDir(address));
    }
    private static native long _getTireLongitudinalDir(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTireLongitudinalDir(PxVec3 value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTireLongitudinalDir(address, value.getAddress());
    }
    private static native void _setTireLongitudinalDir(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTireLateralDir() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_getTireLateralDir(address));
    }
    private static native long _getTireLateralDir(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTireLateralDir(PxVec3 value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTireLateralDir(address, value.getAddress());
    }
    private static native void _setTireLateralDir(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getLongitudinalSlip() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getLongitudinalSlip(address);
    }
    private static native float _getLongitudinalSlip(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLongitudinalSlip(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setLongitudinalSlip(address, value);
    }
    private static native void _setLongitudinalSlip(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getLateralSlip() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getLateralSlip(address);
    }
    private static native float _getLateralSlip(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLateralSlip(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setLateralSlip(address, value);
    }
    private static native void _setLateralSlip(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getSteerAngle() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getSteerAngle(address);
    }
    private static native float _getSteerAngle(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setSteerAngle(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSteerAngle(address, value);
    }
    private static native void _setSteerAngle(long address, float value);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getLocalPose() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxTransform.wrapPointer(_getLocalPose(address));
    }
    private static native long _getLocalPose(long address);

    /**
     * @param value WebIDL type: {@link PxTransform} [Value]
     */
    public void setLocalPose(PxTransform value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setLocalPose(address, value.getAddress());
    }
    private static native void _setLocalPose(long address, long value);

}
