package physx.vehicle;

import physx.common.PxBase;
import physx.physics.PxRigidDynamic;

public class PxVehicleWheels extends PxBase {

    protected PxVehicleWheels() { }

    public static PxVehicleWheels wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheels(address) : null;
    }
    
    protected PxVehicleWheels(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleWheelsSimData} [Value]
     */
    public PxVehicleWheelsSimData getMWheelsSimData() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVehicleWheelsSimData.wrapPointer(_getMWheelsSimData(address));
    }
    private static native long _getMWheelsSimData(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleWheelsSimData} [Value]
     */
    public void setMWheelsSimData(PxVehicleWheelsSimData value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMWheelsSimData(address, value.getAddress());
    }
    private static native void _setMWheelsSimData(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleWheelsDynData} [Value]
     */
    public PxVehicleWheelsDynData getMWheelsDynData() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVehicleWheelsDynData.wrapPointer(_getMWheelsDynData(address));
    }
    private static native long _getMWheelsDynData(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleWheelsDynData} [Value]
     */
    public void setMWheelsDynData(PxVehicleWheelsDynData value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMWheelsDynData(address, value.getAddress());
    }
    private static native void _setMWheelsDynData(long address, long value);

    // Functions

    /**
     * @return WebIDL type: unsigned long
     */
    public int getVehicleType() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getVehicleType(address);
    }
    private static native int _getVehicleType(long address);

    /**
     * @return WebIDL type: {@link PxRigidDynamic}
     */
    public PxRigidDynamic getRigidDynamicActor() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxRigidDynamic.wrapPointer(_getRigidDynamicActor(address));
    }
    private static native long _getRigidDynamicActor(long address);

    /**
     * @return WebIDL type: float
     */
    public float computeForwardSpeed() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _computeForwardSpeed(address);
    }
    private static native float _computeForwardSpeed(long address);

    /**
     * @return WebIDL type: float
     */
    public float computeSidewaysSpeed() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _computeSidewaysSpeed(address);
    }
    private static native float _computeSidewaysSpeed(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbNonDrivenWheels() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getNbNonDrivenWheels(address);
    }
    private static native int _getNbNonDrivenWheels(long address);

}
