package physx.vehicle;

import physx.NativeObject;

public class PxVehicleWheelData extends NativeObject {

    public static PxVehicleWheelData wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelData(address) : null;
    }
    
    protected PxVehicleWheelData(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleWheelData
     */
    public static PxVehicleWheelData createAt(long address) {
        __placement_new_PxVehicleWheelData(address);
        PxVehicleWheelData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleWheelData
     */
    public static <T> PxVehicleWheelData createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleWheelData(address);
        PxVehicleWheelData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleWheelData(long address);

    // Constructors

    public PxVehicleWheelData() {
        address = _PxVehicleWheelData();
    }
    private static native long _PxVehicleWheelData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMRadius() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMRadius(address);
    }
    private static native float _getMRadius(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMRadius(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMRadius(address, value);
    }
    private static native void _setMRadius(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMWidth() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMWidth(address);
    }
    private static native float _getMWidth(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMWidth(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMWidth(address, value);
    }
    private static native void _setMWidth(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMass() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMMass(address);
    }
    private static native float _getMMass(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMass(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMMass(address, value);
    }
    private static native void _setMMass(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMOI() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMMOI(address);
    }
    private static native float _getMMOI(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMOI(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMMOI(address, value);
    }
    private static native void _setMMOI(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMDampingRate() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMDampingRate(address);
    }
    private static native float _getMDampingRate(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMDampingRate(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMDampingRate(address, value);
    }
    private static native void _setMDampingRate(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxBrakeTorque() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMMaxBrakeTorque(address);
    }
    private static native float _getMMaxBrakeTorque(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxBrakeTorque(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMMaxBrakeTorque(address, value);
    }
    private static native void _setMMaxBrakeTorque(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxHandBrakeTorque() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMMaxHandBrakeTorque(address);
    }
    private static native float _getMMaxHandBrakeTorque(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxHandBrakeTorque(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMMaxHandBrakeTorque(address, value);
    }
    private static native void _setMMaxHandBrakeTorque(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxSteer() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMMaxSteer(address);
    }
    private static native float _getMMaxSteer(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxSteer(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMMaxSteer(address, value);
    }
    private static native void _setMMaxSteer(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMToeAngle() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMToeAngle(address);
    }
    private static native float _getMToeAngle(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMToeAngle(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMToeAngle(address, value);
    }
    private static native void _setMToeAngle(long address, float value);

}
