package physx.vehicle;

import physx.NativeObject;

public class PxVehicleTireLoadFilterData extends NativeObject {

    public static PxVehicleTireLoadFilterData wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireLoadFilterData(address) : null;
    }
    
    protected PxVehicleTireLoadFilterData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTireLoadFilterData() {
        address = _PxVehicleTireLoadFilterData();
    }
    private static native long _PxVehicleTireLoadFilterData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMMinNormalisedLoad() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMMinNormalisedLoad(address);
    }
    private static native float _getMMinNormalisedLoad(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMinNormalisedLoad(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMMinNormalisedLoad(address, value);
    }
    private static native void _setMMinNormalisedLoad(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMinFilteredNormalisedLoad() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMMinFilteredNormalisedLoad(address);
    }
    private static native float _getMMinFilteredNormalisedLoad(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMinFilteredNormalisedLoad(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMMinFilteredNormalisedLoad(address, value);
    }
    private static native void _setMMinFilteredNormalisedLoad(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxNormalisedLoad() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMMaxNormalisedLoad(address);
    }
    private static native float _getMMaxNormalisedLoad(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxNormalisedLoad(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMMaxNormalisedLoad(address, value);
    }
    private static native void _setMMaxNormalisedLoad(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxFilteredNormalisedLoad() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMMaxFilteredNormalisedLoad(address);
    }
    private static native float _getMMaxFilteredNormalisedLoad(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxFilteredNormalisedLoad(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMMaxFilteredNormalisedLoad(address, value);
    }
    private static native void _setMMaxFilteredNormalisedLoad(long address, float value);

    // Functions

    /**
     * @return WebIDL type: float
     */
    public float getDenominator() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getDenominator(address);
    }
    private static native float _getDenominator(long address);

}
