package physx.vehicle;

import physx.NativeObject;

public class PxVehicleTireData extends NativeObject {

    public static PxVehicleTireData wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireData(address) : null;
    }
    
    protected PxVehicleTireData(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleTireData
     */
    public static PxVehicleTireData createAt(long address) {
        __placement_new_PxVehicleTireData(address);
        PxVehicleTireData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleTireData
     */
    public static <T> PxVehicleTireData createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleTireData(address);
        PxVehicleTireData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleTireData(long address);

    // Constructors

    public PxVehicleTireData() {
        address = _PxVehicleTireData();
    }
    private static native long _PxVehicleTireData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMLatStiffX() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMLatStiffX(address);
    }
    private static native float _getMLatStiffX(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMLatStiffX(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMLatStiffX(address, value);
    }
    private static native void _setMLatStiffX(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMLatStiffY() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMLatStiffY(address);
    }
    private static native float _getMLatStiffY(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMLatStiffY(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMLatStiffY(address, value);
    }
    private static native void _setMLatStiffY(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMLongitudinalStiffnessPerUnitGravity() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMLongitudinalStiffnessPerUnitGravity(address);
    }
    private static native float _getMLongitudinalStiffnessPerUnitGravity(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMLongitudinalStiffnessPerUnitGravity(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMLongitudinalStiffnessPerUnitGravity(address, value);
    }
    private static native void _setMLongitudinalStiffnessPerUnitGravity(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMCamberStiffnessPerUnitGravity() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMCamberStiffnessPerUnitGravity(address);
    }
    private static native float _getMCamberStiffnessPerUnitGravity(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMCamberStiffnessPerUnitGravity(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMCamberStiffnessPerUnitGravity(address, value);
    }
    private static native void _setMCamberStiffnessPerUnitGravity(long address, float value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMType() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMType(address);
    }
    private static native int _getMType(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMType(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMType(address, value);
    }
    private static native void _setMType(long address, int value);

}
