package physx.vehicle;

import physx.NativeObject;

public class PxVehicleGearsData extends NativeObject {

    public static PxVehicleGearsData wrapPointer(long address) {
        return address != 0L ? new PxVehicleGearsData(address) : null;
    }
    
    protected PxVehicleGearsData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleGearsData() {
        address = _PxVehicleGearsData();
    }
    private static native long _PxVehicleGearsData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getMRatios(int index) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMRatios(address, index);
    }
    private static native float _getMRatios(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setMRatios(int index, float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMRatios(address, index, value);
    }
    private static native void _setMRatios(long address, int index, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMFinalRatio() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMFinalRatio(address);
    }
    private static native float _getMFinalRatio(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMFinalRatio(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMFinalRatio(address, value);
    }
    private static native void _setMFinalRatio(long address, float value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMNbRatios() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMNbRatios(address);
    }
    private static native int _getMNbRatios(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMNbRatios(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMNbRatios(address, value);
    }
    private static native void _setMNbRatios(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getMSwitchTime() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMSwitchTime(address);
    }
    private static native float _getMSwitchTime(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMSwitchTime(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMSwitchTime(address, value);
    }
    private static native void _setMSwitchTime(long address, float value);

    // Functions

    /**
     * @param a WebIDL type: {@link PxVehicleGearEnum} [enum]
     * @return WebIDL type: float
     */
    public float getGearRatio(int a) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getGearRatio(address, a);
    }
    private static native float _getGearRatio(long address, int a);

    /**
     * @param a     WebIDL type: {@link PxVehicleGearEnum} [enum]
     * @param ratio WebIDL type: float
     */
    public void setGearRatio(int a, float ratio) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setGearRatio(address, a, ratio);
    }
    private static native void _setGearRatio(long address, int a, float ratio);

}
