package physx.vehicle;

import physx.NativeObject;

public class PxVehicleDrivableSurfaceType extends NativeObject {

    public static PxVehicleDrivableSurfaceType wrapPointer(long address) {
        return address != 0L ? new PxVehicleDrivableSurfaceType(address) : null;
    }
    
    protected PxVehicleDrivableSurfaceType(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleDrivableSurfaceType() {
        address = _PxVehicleDrivableSurfaceType();
    }
    private static native long _PxVehicleDrivableSurfaceType();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMType() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMType(address);
    }
    private static native int _getMType(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMType(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMType(address, value);
    }
    private static native void _setMType(long address, int value);

}
