package physx.vehicle;

import physx.NativeObject;

public class PxVehicleDifferential4WData extends NativeObject {

    public static PxVehicleDifferential4WData wrapPointer(long address) {
        return address != 0L ? new PxVehicleDifferential4WData(address) : null;
    }
    
    protected PxVehicleDifferential4WData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleDifferential4WData() {
        address = _PxVehicleDifferential4WData();
    }
    private static native long _PxVehicleDifferential4WData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMFrontRearSplit() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMFrontRearSplit(address);
    }
    private static native float _getMFrontRearSplit(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMFrontRearSplit(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMFrontRearSplit(address, value);
    }
    private static native void _setMFrontRearSplit(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMFrontLeftRightSplit() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMFrontLeftRightSplit(address);
    }
    private static native float _getMFrontLeftRightSplit(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMFrontLeftRightSplit(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMFrontLeftRightSplit(address, value);
    }
    private static native void _setMFrontLeftRightSplit(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMRearLeftRightSplit() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMRearLeftRightSplit(address);
    }
    private static native float _getMRearLeftRightSplit(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMRearLeftRightSplit(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMRearLeftRightSplit(address, value);
    }
    private static native void _setMRearLeftRightSplit(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMCentreBias() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMCentreBias(address);
    }
    private static native float _getMCentreBias(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMCentreBias(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMCentreBias(address, value);
    }
    private static native void _setMCentreBias(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMFrontBias() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMFrontBias(address);
    }
    private static native float _getMFrontBias(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMFrontBias(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMFrontBias(address, value);
    }
    private static native void _setMFrontBias(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMRearBias() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMRearBias(address);
    }
    private static native float _getMRearBias(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMRearBias(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMRearBias(address, value);
    }
    private static native void _setMRearBias(long address, float value);

    /**
     * @return WebIDL type: {@link PxVehicleDifferential4WDataEnum} [enum]
     */
    public int getMType() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMType(address);
    }
    private static native int _getMType(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDifferential4WDataEnum} [enum]
     */
    public void setMType(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMType(address, value);
    }
    private static native void _setMType(long address, int value);

}
