package physx.vehicle;

import physx.NativeObject;

public class PxVehicleClutchData extends NativeObject {

    public static PxVehicleClutchData wrapPointer(long address) {
        return address != 0L ? new PxVehicleClutchData(address) : null;
    }
    
    protected PxVehicleClutchData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleClutchData() {
        address = _PxVehicleClutchData();
    }
    private static native long _PxVehicleClutchData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMStrength() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMStrength(address);
    }
    private static native float _getMStrength(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMStrength(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMStrength(address, value);
    }
    private static native void _setMStrength(long address, float value);

    /**
     * @return WebIDL type: {@link PxVehicleClutchAccuracyModeEnum} [enum]
     */
    public int getMAccuracyMode() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMAccuracyMode(address);
    }
    private static native int _getMAccuracyMode(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleClutchAccuracyModeEnum} [enum]
     */
    public void setMAccuracyMode(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMAccuracyMode(address, value);
    }
    private static native void _setMAccuracyMode(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMEstimateIterations() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMEstimateIterations(address);
    }
    private static native int _getMEstimateIterations(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMEstimateIterations(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMEstimateIterations(address, value);
    }
    private static native void _setMEstimateIterations(long address, int value);

}
