package physx.vehicle;

import physx.NativeObject;

public class PxVehicleAntiRollBarData extends NativeObject {

    public static PxVehicleAntiRollBarData wrapPointer(long address) {
        return address != 0L ? new PxVehicleAntiRollBarData(address) : null;
    }
    
    protected PxVehicleAntiRollBarData(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleAntiRollBarData
     */
    public static PxVehicleAntiRollBarData createAt(long address) {
        __placement_new_PxVehicleAntiRollBarData(address);
        PxVehicleAntiRollBarData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleAntiRollBarData
     */
    public static <T> PxVehicleAntiRollBarData createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleAntiRollBarData(address);
        PxVehicleAntiRollBarData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleAntiRollBarData(long address);

    // Constructors

    public PxVehicleAntiRollBarData() {
        address = _PxVehicleAntiRollBarData();
    }
    private static native long _PxVehicleAntiRollBarData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMWheel0() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMWheel0(address);
    }
    private static native int _getMWheel0(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMWheel0(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMWheel0(address, value);
    }
    private static native void _setMWheel0(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMWheel1() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMWheel1(address);
    }
    private static native int _getMWheel1(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMWheel1(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMWheel1(address, value);
    }
    private static native void _setMWheel1(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getMStiffness() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMStiffness(address);
    }
    private static native float _getMStiffness(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMStiffness(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMStiffness(address, value);
    }
    private static native void _setMStiffness(long address, float value);

}
