package physx.vehicle;

import physx.NativeObject;

public class PxEngineTorqueLookupTable extends NativeObject {

    public static PxEngineTorqueLookupTable wrapPointer(long address) {
        return address != 0L ? new PxEngineTorqueLookupTable(address) : null;
    }
    
    protected PxEngineTorqueLookupTable(long address) {
        super(address);
    }

    // Constructors

    public PxEngineTorqueLookupTable() {
        address = _PxEngineTorqueLookupTable();
    }
    private static native long _PxEngineTorqueLookupTable();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getMDataPairs(int index) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMDataPairs(address, index);
    }
    private static native float _getMDataPairs(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setMDataPairs(int index, float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMDataPairs(address, index, value);
    }
    private static native void _setMDataPairs(long address, int index, float value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMNbDataPairs() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMNbDataPairs(address);
    }
    private static native int _getMNbDataPairs(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMNbDataPairs(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMNbDataPairs(address, value);
    }
    private static native void _setMNbDataPairs(long address, int value);

    // Functions

    /**
     * @param x WebIDL type: float
     * @param y WebIDL type: float
     */
    public void addPair(float x, float y) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _addPair(address, x, y);
    }
    private static native void _addPair(long address, float x, float y);

    /**
     * @param x WebIDL type: float
     * @return WebIDL type: float
     */
    public float getYVal(float x) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getYVal(address, x);
    }
    private static native float _getYVal(long address, float x);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbDataPairs() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getNbDataPairs(address);
    }
    private static native int _getNbDataPairs(long address);

    public void clear() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _clear(address);
    }
    private static native void _clear(long address);

    /**
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float getX(int i) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getX(address, i);
    }
    private static native float _getX(long address, int i);

    /**
     * @param i WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float getY(int i) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getY(address, i);
    }
    private static native float _getY(long address, int i);

}
