package physx.support;

import physx.NativeObject;
import physx.common.PxVec3;

public class Vector_PxVec3 extends NativeObject {

    public static Vector_PxVec3 wrapPointer(long address) {
        return address != 0L ? new Vector_PxVec3(address) : null;
    }
    
    protected Vector_PxVec3(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxVec3() {
        address = _Vector_PxVec3();
    }
    private static native long _Vector_PxVec3();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxVec3(int size) {
        address = _Vector_PxVec3(size);
    }
    private static native long _Vector_PxVec3(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVec3} [Ref]
     */
    public PxVec3 at(int index) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return WebIDL type: {@link PxVec3}
     */
    public PxVec3 data() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Ref]
     */
    public void push_back(PxVec3 value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

}
