package physx.physics;

import physx.NativeObject;

public class PxTriggerPair extends NativeObject {

    protected PxTriggerPair() { }

    public static PxTriggerPair wrapPointer(long address) {
        return address != 0L ? new PxTriggerPair(address) : null;
    }
    
    protected PxTriggerPair(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getTriggerShape() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxShape.wrapPointer(_getTriggerShape(address));
    }
    private static native long _getTriggerShape(long address);

    /**
     * @param value WebIDL type: {@link PxShape}
     */
    public void setTriggerShape(PxShape value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTriggerShape(address, value.getAddress());
    }
    private static native void _setTriggerShape(long address, long value);

    /**
     * @return WebIDL type: {@link PxRigidActor}
     */
    public PxRigidActor getTriggerActor() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxRigidActor.wrapPointer(_getTriggerActor(address));
    }
    private static native long _getTriggerActor(long address);

    /**
     * @param value WebIDL type: {@link PxRigidActor}
     */
    public void setTriggerActor(PxRigidActor value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTriggerActor(address, value.getAddress());
    }
    private static native void _setTriggerActor(long address, long value);

    /**
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getOtherShape() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxShape.wrapPointer(_getOtherShape(address));
    }
    private static native long _getOtherShape(long address);

    /**
     * @param value WebIDL type: {@link PxShape}
     */
    public void setOtherShape(PxShape value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setOtherShape(address, value.getAddress());
    }
    private static native void _setOtherShape(long address, long value);

    /**
     * @return WebIDL type: {@link PxRigidActor}
     */
    public PxRigidActor getOtherActor() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxRigidActor.wrapPointer(_getOtherActor(address));
    }
    private static native long _getOtherActor(long address);

    /**
     * @param value WebIDL type: {@link PxRigidActor}
     */
    public void setOtherActor(PxRigidActor value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setOtherActor(address, value.getAddress());
    }
    private static native void _setOtherActor(long address, long value);

    /**
     * @return WebIDL type: {@link PxPairFlagEnum} [enum]
     */
    public int getStatus() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getStatus(address);
    }
    private static native int _getStatus(long address);

    /**
     * @param value WebIDL type: {@link PxPairFlagEnum} [enum]
     */
    public void setStatus(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setStatus(address, value);
    }
    private static native void _setStatus(long address, int value);

    /**
     * @return WebIDL type: {@link PxTriggerPairFlags} [Value]
     */
    public PxTriggerPairFlags getFlags() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxTriggerPairFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxTriggerPairFlags} [Value]
     */
    public void setFlags(PxTriggerPairFlags value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

}
