package physx.physics;

import physx.NativeObject;

public class PxSweepQueryResult extends NativeObject {

    protected PxSweepQueryResult() { }

    public static PxSweepQueryResult wrapPointer(long address) {
        return address != 0L ? new PxSweepQueryResult(address) : null;
    }
    
    protected PxSweepQueryResult(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxSweepHit} [Value]
     */
    public PxSweepHit getBlock() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxSweepHit.wrapPointer(_getBlock(address));
    }
    private static native long _getBlock(long address);

    /**
     * @param value WebIDL type: {@link PxSweepHit} [Value]
     */
    public void setBlock(PxSweepHit value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setBlock(address, value.getAddress());
    }
    private static native void _setBlock(long address, long value);

    /**
     * @return WebIDL type: {@link PxSweepHit}
     */
    public PxSweepHit getTouches() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxSweepHit.wrapPointer(_getTouches(address));
    }
    private static native long _getTouches(long address);

    /**
     * @param value WebIDL type: {@link PxSweepHit}
     */
    public void setTouches(PxSweepHit value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTouches(address, value.getAddress());
    }
    private static native void _setTouches(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbTouches() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getNbTouches(address);
    }
    private static native int _getNbTouches(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbTouches(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setNbTouches(address, value);
    }
    private static native void _setNbTouches(long address, int value);

    /**
     * @return WebIDL type: any
     */
    public NativeObject getUserData() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: any
     */
    public void setUserData(NativeObject value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    /**
     * @return WebIDL type: octet
     */
    public byte getQueryStatus() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getQueryStatus(address);
    }
    private static native byte _getQueryStatus(long address);

    /**
     * @param value WebIDL type: octet
     */
    public void setQueryStatus(byte value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setQueryStatus(address, value);
    }
    private static native void _setQueryStatus(long address, byte value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getHasBlock() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getHasBlock(address);
    }
    private static native boolean _getHasBlock(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setHasBlock(boolean value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setHasBlock(address, value);
    }
    private static native void _setHasBlock(long address, boolean value);

    // Functions

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAnyHits() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getNbAnyHits(address);
    }
    private static native int _getNbAnyHits(long address);

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxSweepHit} [Const, Ref]
     */
    public PxSweepHit getAnyHit(int index) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxSweepHit.wrapPointer(_getAnyHit(address, index));
    }
    private static native long _getAnyHit(long address, int index);

}
