package physx.physics;

import physx.common.PxBase;
import physx.common.PxTransform;

public class PxShape extends PxBase {

    protected PxShape() { }

    public static PxShape wrapPointer(long address) {
        return address != 0L ? new PxShape(address) : null;
    }
    
    protected PxShape(long address) {
        super(address);
    }

    // Functions

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setLocalPose(PxTransform pose) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setLocalPose(address, pose.getAddress());
    }
    private static native void _setLocalPose(long address, long pose);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getLocalPose() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxTransform.wrapPointer(_getLocalPose(address));
    }
    private static native long _getLocalPose(long address);

    /**
     * @param data WebIDL type: {@link PxFilterData} [Const, Ref]
     */
    public void setSimulationFilterData(PxFilterData data) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSimulationFilterData(address, data.getAddress());
    }
    private static native void _setSimulationFilterData(long address, long data);

    /**
     * @return WebIDL type: {@link PxFilterData} [Value]
     */
    public PxFilterData getSimulationFilterData() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxFilterData.wrapPointer(_getSimulationFilterData(address));
    }
    private static native long _getSimulationFilterData(long address);

    /**
     * @param data WebIDL type: {@link PxFilterData} [Const, Ref]
     */
    public void setQueryFilterData(PxFilterData data) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setQueryFilterData(address, data.getAddress());
    }
    private static native void _setQueryFilterData(long address, long data);

    /**
     * @return WebIDL type: {@link PxFilterData} [Value]
     */
    public PxFilterData getQueryFilterData() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxFilterData.wrapPointer(_getQueryFilterData(address));
    }
    private static native long _getQueryFilterData(long address);

}
