package physx.physics;

import physx.NativeObject;
import physx.common.PxCpuDispatcher;
import physx.common.PxTolerancesScale;
import physx.common.PxVec3;

public class PxSceneDesc extends NativeObject {

    protected PxSceneDesc() { }

    public static PxSceneDesc wrapPointer(long address) {
        return address != 0L ? new PxSceneDesc(address) : null;
    }
    
    protected PxSceneDesc(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param scale   WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     * @return Stack allocated object of PxSceneDesc
     */
    public static PxSceneDesc createAt(long address, PxTolerancesScale scale) {
        __placement_new_PxSceneDesc(address, scale.getAddress());
        PxSceneDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param scale     WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     * @return Stack allocated object of PxSceneDesc
     */
    public static <T> PxSceneDesc createAt(T allocator, Allocator<T> allocate, PxTolerancesScale scale) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxSceneDesc(address, scale.getAddress());
        PxSceneDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxSceneDesc(long address, long scale);

    // Constructors

    /**
     * @param scale WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     */
    public PxSceneDesc(PxTolerancesScale scale) {
        address = _PxSceneDesc(scale.getAddress());
    }
    private static native long _PxSceneDesc(long scale);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getGravity() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_getGravity(address));
    }
    private static native long _getGravity(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setGravity(PxVec3 value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setGravity(address, value.getAddress());
    }
    private static native void _setGravity(long address, long value);

    /**
     * @return WebIDL type: {@link PxSimulationEventCallback}
     */
    public PxSimulationEventCallback getSimulationEventCallback() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxSimulationEventCallback.wrapPointer(_getSimulationEventCallback(address));
    }
    private static native long _getSimulationEventCallback(long address);

    /**
     * @param value WebIDL type: {@link PxSimulationEventCallback}
     */
    public void setSimulationEventCallback(PxSimulationEventCallback value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSimulationEventCallback(address, value.getAddress());
    }
    private static native void _setSimulationEventCallback(long address, long value);

    /**
     * @return WebIDL type: {@link PxSimulationFilterShader} [Value]
     */
    public PxSimulationFilterShader getFilterShader() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxSimulationFilterShader.wrapPointer(_getFilterShader(address));
    }
    private static native long _getFilterShader(long address);

    /**
     * @param value WebIDL type: {@link PxSimulationFilterShader} [Value]
     */
    public void setFilterShader(PxSimulationFilterShader value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setFilterShader(address, value.getAddress());
    }
    private static native void _setFilterShader(long address, long value);

    /**
     * @return WebIDL type: {@link PxCpuDispatcher}
     */
    public PxCpuDispatcher getCpuDispatcher() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxCpuDispatcher.wrapPointer(_getCpuDispatcher(address));
    }
    private static native long _getCpuDispatcher(long address);

    /**
     * @param value WebIDL type: {@link PxCpuDispatcher}
     */
    public void setCpuDispatcher(PxCpuDispatcher value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setCpuDispatcher(address, value.getAddress());
    }
    private static native void _setCpuDispatcher(long address, long value);

    /**
     * @return WebIDL type: {@link PxSceneFlags} [Value]
     */
    public PxSceneFlags getFlags() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxSceneFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxSceneFlags} [Value]
     */
    public void setFlags(PxSceneFlags value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

}
