package physx.physics;


public class PxRigidDynamic extends PxRigidBody {

    protected PxRigidDynamic() { }

    public static PxRigidDynamic wrapPointer(long address) {
        return address != 0L ? new PxRigidDynamic(address) : null;
    }
    
    protected PxRigidDynamic(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isSleeping() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _isSleeping(address);
    }
    private static native boolean _isSleeping(long address);

    /**
     * @param threshold WebIDL type: float
     */
    public void setSleepThreshold(float threshold) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSleepThreshold(address, threshold);
    }
    private static native void _setSleepThreshold(long address, float threshold);

    /**
     * @return WebIDL type: float
     */
    public float getSleepThreshold() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getSleepThreshold(address);
    }
    private static native float _getSleepThreshold(long address);

    /**
     * @param threshold WebIDL type: float
     */
    public void setStabilizationThreshold(float threshold) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setStabilizationThreshold(address, threshold);
    }
    private static native void _setStabilizationThreshold(long address, float threshold);

    /**
     * @return WebIDL type: float
     */
    public float getStabilizationThreshold() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getStabilizationThreshold(address);
    }
    private static native float _getStabilizationThreshold(long address);

    /**
     * @return WebIDL type: {@link PxRigidDynamicLockFlags} [Value]
     */
    public PxRigidDynamicLockFlags getRigidDynamicLockFlags() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxRigidDynamicLockFlags.wrapPointer(_getRigidDynamicLockFlags(address));
    }
    private static native long _getRigidDynamicLockFlags(long address);

    /**
     * @param flag  WebIDL type: {@link PxRigidDynamicLockFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setRigidDynamicLockFlag(int flag, boolean value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setRigidDynamicLockFlag(address, flag, value);
    }
    private static native void _setRigidDynamicLockFlag(long address, int flag, boolean value);

    /**
     * @param flags WebIDL type: {@link PxRigidDynamicLockFlags} [Ref]
     */
    public void setRigidDynamicLockFlags(PxRigidDynamicLockFlags flags) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setRigidDynamicLockFlags(address, flags.getAddress());
    }
    private static native void _setRigidDynamicLockFlags(long address, long flags);

    /**
     * @param wakeCounterValue WebIDL type: float
     */
    public void setWakeCounter(float wakeCounterValue) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setWakeCounter(address, wakeCounterValue);
    }
    private static native void _setWakeCounter(long address, float wakeCounterValue);

    /**
     * @return WebIDL type: float
     */
    public float getWakeCounter() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getWakeCounter(address);
    }
    private static native float _getWakeCounter(long address);

    public void wakeUp() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _wakeUp(address);
    }
    private static native void _wakeUp(long address);

    public void putToSleep() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _putToSleep(address);
    }
    private static native void _putToSleep(long address);

    /**
     * @param minPositionIters WebIDL type: unsigned long
     */
    public void setSolverIterationCounts(int minPositionIters) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSolverIterationCounts(address, minPositionIters);
    }
    private static native void _setSolverIterationCounts(long address, int minPositionIters);

    /**
     * @param minPositionIters WebIDL type: unsigned long
     * @param minVelocityIters WebIDL type: unsigned long
     */
    public void setSolverIterationCounts(int minPositionIters, int minVelocityIters) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSolverIterationCounts(address, minPositionIters, minVelocityIters);
    }
    private static native void _setSolverIterationCounts(long address, int minPositionIters, int minVelocityIters);

    /**
     * @return WebIDL type: float
     */
    public float getContactReportThreshold() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getContactReportThreshold(address);
    }
    private static native float _getContactReportThreshold(long address);

    /**
     * @param threshold WebIDL type: float
     */
    public void setContactReportThreshold(float threshold) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setContactReportThreshold(address, threshold);
    }
    private static native void _setContactReportThreshold(long address, float threshold);

}
