package physx.physics;


public class PxRaycastHit extends PxLocationHit {

    public static PxRaycastHit wrapPointer(long address) {
        return address != 0L ? new PxRaycastHit(address) : null;
    }
    
    protected PxRaycastHit(long address) {
        super(address);
    }

    // Constructors

    public PxRaycastHit() {
        address = _PxRaycastHit();
    }
    private static native long _PxRaycastHit();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getU() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getU(address);
    }
    private static native float _getU(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setU(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setU(address, value);
    }
    private static native void _setU(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getV() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getV(address);
    }
    private static native float _getV(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setV(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setV(address, value);
    }
    private static native void _setV(long address, float value);

}
