package physx.physics;

import physx.NativeObject;

public class PxHitFlags extends NativeObject {

    protected PxHitFlags() { }

    public static PxHitFlags wrapPointer(long address) {
        return address != 0L ? new PxHitFlags(address) : null;
    }
    
    protected PxHitFlags(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: unsigned short
     * @return Stack allocated object of PxHitFlags
     */
    public static PxHitFlags createAt(long address, short flags) {
        __placement_new_PxHitFlags(address, flags);
        PxHitFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: unsigned short
     * @return Stack allocated object of PxHitFlags
     */
    public static <T> PxHitFlags createAt(T allocator, Allocator<T> allocate, short flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxHitFlags(address, flags);
        PxHitFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxHitFlags(long address, short flags);

    // Constructors

    /**
     * @param flags WebIDL type: unsigned short
     */
    public PxHitFlags(short flags) {
        address = _PxHitFlags(flags);
    }
    private static native long _PxHitFlags(short flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxHitFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(int flag) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxHitFlagEnum} [enum]
     */
    public void set(int flag) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxHitFlagEnum} [enum]
     */
    public void clear(int flag) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
