package physx.physics;

import physx.NativeObject;

public class PxContactPairFlags extends NativeObject {

    protected PxContactPairFlags() { }

    public static PxContactPairFlags wrapPointer(long address) {
        return address != 0L ? new PxContactPairFlags(address) : null;
    }
    
    protected PxContactPairFlags(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param flags WebIDL type: unsigned short
     */
    public PxContactPairFlags(short flags) {
        address = _PxContactPairFlags(flags);
    }
    private static native long _PxContactPairFlags(short flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxContactPairFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(int flag) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxContactPairFlagEnum} [enum]
     */
    public void set(int flag) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxContactPairFlagEnum} [enum]
     */
    public void clear(int flag) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
