package physx.physics;

import physx.NativeObject;

public class PxBatchQueryMemory extends NativeObject {

    protected PxBatchQueryMemory() { }

    public static PxBatchQueryMemory wrapPointer(long address) {
        return address != 0L ? new PxBatchQueryMemory(address) : null;
    }
    
    protected PxBatchQueryMemory(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxRaycastQueryResult}
     */
    public PxRaycastQueryResult getUserRaycastResultBuffer() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxRaycastQueryResult.wrapPointer(_getUserRaycastResultBuffer(address));
    }
    private static native long _getUserRaycastResultBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxRaycastQueryResult}
     */
    public void setUserRaycastResultBuffer(PxRaycastQueryResult value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setUserRaycastResultBuffer(address, value.getAddress());
    }
    private static native void _setUserRaycastResultBuffer(long address, long value);

    /**
     * @return WebIDL type: {@link PxRaycastHit}
     */
    public PxRaycastHit getUserRaycastTouchBuffer() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxRaycastHit.wrapPointer(_getUserRaycastTouchBuffer(address));
    }
    private static native long _getUserRaycastTouchBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxRaycastHit}
     */
    public void setUserRaycastTouchBuffer(PxRaycastHit value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setUserRaycastTouchBuffer(address, value.getAddress());
    }
    private static native void _setUserRaycastTouchBuffer(long address, long value);

    /**
     * @return WebIDL type: {@link PxSweepQueryResult}
     */
    public PxSweepQueryResult getUserSweepResultBuffer() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxSweepQueryResult.wrapPointer(_getUserSweepResultBuffer(address));
    }
    private static native long _getUserSweepResultBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxSweepQueryResult}
     */
    public void setUserSweepResultBuffer(PxSweepQueryResult value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setUserSweepResultBuffer(address, value.getAddress());
    }
    private static native void _setUserSweepResultBuffer(long address, long value);

    /**
     * @return WebIDL type: {@link PxSweepHit}
     */
    public PxSweepHit getUserSweepTouchBuffer() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxSweepHit.wrapPointer(_getUserSweepTouchBuffer(address));
    }
    private static native long _getUserSweepTouchBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxSweepHit}
     */
    public void setUserSweepTouchBuffer(PxSweepHit value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setUserSweepTouchBuffer(address, value.getAddress());
    }
    private static native void _setUserSweepTouchBuffer(long address, long value);

    /**
     * @return WebIDL type: {@link PxOverlapQueryResult}
     */
    public PxOverlapQueryResult getUserOverlapResultBuffer() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxOverlapQueryResult.wrapPointer(_getUserOverlapResultBuffer(address));
    }
    private static native long _getUserOverlapResultBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxOverlapQueryResult}
     */
    public void setUserOverlapResultBuffer(PxOverlapQueryResult value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setUserOverlapResultBuffer(address, value.getAddress());
    }
    private static native void _setUserOverlapResultBuffer(long address, long value);

    /**
     * @return WebIDL type: {@link PxOverlapHit}
     */
    public PxOverlapHit getUserOverlapTouchBuffer() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxOverlapHit.wrapPointer(_getUserOverlapTouchBuffer(address));
    }
    private static native long _getUserOverlapTouchBuffer(long address);

    /**
     * @param value WebIDL type: {@link PxOverlapHit}
     */
    public void setUserOverlapTouchBuffer(PxOverlapHit value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setUserOverlapTouchBuffer(address, value.getAddress());
    }
    private static native void _setUserOverlapTouchBuffer(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getRaycastTouchBufferSize() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getRaycastTouchBufferSize(address);
    }
    private static native int _getRaycastTouchBufferSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setRaycastTouchBufferSize(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setRaycastTouchBufferSize(address, value);
    }
    private static native void _setRaycastTouchBufferSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSweepTouchBufferSize() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getSweepTouchBufferSize(address);
    }
    private static native int _getSweepTouchBufferSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setSweepTouchBufferSize(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSweepTouchBufferSize(address, value);
    }
    private static native void _setSweepTouchBufferSize(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getOverlapTouchBufferSize() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getOverlapTouchBufferSize(address);
    }
    private static native int _getOverlapTouchBufferSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setOverlapTouchBufferSize(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setOverlapTouchBufferSize(address, value);
    }
    private static native void _setOverlapTouchBufferSize(long address, int value);

}
