package physx.physics;

import physx.NativeObject;

public class PxBatchQueryDesc extends NativeObject {

    protected PxBatchQueryDesc() { }

    public static PxBatchQueryDesc wrapPointer(long address) {
        return address != 0L ? new PxBatchQueryDesc(address) : null;
    }
    
    protected PxBatchQueryDesc(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address               Pre-allocated memory, where the object is created.
     * @param maxRaycastsPerExecute WebIDL type: unsigned long
     * @param maxSweepsPerExecute   WebIDL type: unsigned long
     * @param maxOverlapsPerExecute WebIDL type: unsigned long
     * @return Stack allocated object of PxBatchQueryDesc
     */
    public static PxBatchQueryDesc createAt(long address, int maxRaycastsPerExecute, int maxSweepsPerExecute, int maxOverlapsPerExecute) {
        __placement_new_PxBatchQueryDesc(address, maxRaycastsPerExecute, maxSweepsPerExecute, maxOverlapsPerExecute);
        PxBatchQueryDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>                   Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator             Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate              Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param maxRaycastsPerExecute WebIDL type: unsigned long
     * @param maxSweepsPerExecute   WebIDL type: unsigned long
     * @param maxOverlapsPerExecute WebIDL type: unsigned long
     * @return Stack allocated object of PxBatchQueryDesc
     */
    public static <T> PxBatchQueryDesc createAt(T allocator, Allocator<T> allocate, int maxRaycastsPerExecute, int maxSweepsPerExecute, int maxOverlapsPerExecute) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxBatchQueryDesc(address, maxRaycastsPerExecute, maxSweepsPerExecute, maxOverlapsPerExecute);
        PxBatchQueryDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxBatchQueryDesc(long address, int maxRaycastsPerExecute, int maxSweepsPerExecute, int maxOverlapsPerExecute);

    // Constructors

    /**
     * @param maxRaycastsPerExecute WebIDL type: unsigned long
     * @param maxSweepsPerExecute   WebIDL type: unsigned long
     * @param maxOverlapsPerExecute WebIDL type: unsigned long
     */
    public PxBatchQueryDesc(int maxRaycastsPerExecute, int maxSweepsPerExecute, int maxOverlapsPerExecute) {
        address = _PxBatchQueryDesc(maxRaycastsPerExecute, maxSweepsPerExecute, maxOverlapsPerExecute);
    }
    private static native long _PxBatchQueryDesc(int maxRaycastsPerExecute, int maxSweepsPerExecute, int maxOverlapsPerExecute);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: any
     */
    public NativeObject getFilterShaderData() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return NativeObject.wrapPointer(_getFilterShaderData(address));
    }
    private static native long _getFilterShaderData(long address);

    /**
     * @param value WebIDL type: any
     */
    public void setFilterShaderData(NativeObject value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setFilterShaderData(address, value.getAddress());
    }
    private static native void _setFilterShaderData(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFilterShaderDataSize() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getFilterShaderDataSize(address);
    }
    private static native int _getFilterShaderDataSize(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setFilterShaderDataSize(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setFilterShaderDataSize(address, value);
    }
    private static native void _setFilterShaderDataSize(long address, int value);

    /**
     * @return WebIDL type: {@link PxBatchQueryPreFilterShader} [Value]
     */
    public PxBatchQueryPreFilterShader getPreFilterShader() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBatchQueryPreFilterShader.wrapPointer(_getPreFilterShader(address));
    }
    private static native long _getPreFilterShader(long address);

    /**
     * @param value WebIDL type: {@link PxBatchQueryPreFilterShader} [Value]
     */
    public void setPreFilterShader(PxBatchQueryPreFilterShader value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setPreFilterShader(address, (value != null ? value.getAddress() : 0L));
    }
    private static native void _setPreFilterShader(long address, long value);

    /**
     * @return WebIDL type: {@link PxBatchQueryPostFilterShader} [Value]
     */
    public PxBatchQueryPostFilterShader getPostFilterShader() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBatchQueryPostFilterShader.wrapPointer(_getPostFilterShader(address));
    }
    private static native long _getPostFilterShader(long address);

    /**
     * @param value WebIDL type: {@link PxBatchQueryPostFilterShader} [Value]
     */
    public void setPostFilterShader(PxBatchQueryPostFilterShader value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setPostFilterShader(address, (value != null ? value.getAddress() : 0L));
    }
    private static native void _setPostFilterShader(long address, long value);

    /**
     * @return WebIDL type: {@link PxBatchQueryMemory} [Value]
     */
    public PxBatchQueryMemory getQueryMemory() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBatchQueryMemory.wrapPointer(_getQueryMemory(address));
    }
    private static native long _getQueryMemory(long address);

    /**
     * @param value WebIDL type: {@link PxBatchQueryMemory} [Value]
     */
    public void setQueryMemory(PxBatchQueryMemory value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setQueryMemory(address, value.getAddress());
    }
    private static native void _setQueryMemory(long address, long value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
