package physx.physics;

import physx.NativeObject;

public class PxBatchQuery extends NativeObject {

    protected PxBatchQuery() { }

    public static PxBatchQuery wrapPointer(long address) {
        return address != 0L ? new PxBatchQuery(address) : null;
    }
    
    protected PxBatchQuery(long address) {
        super(address);
    }

    // Functions

    public void execute() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _execute(address);
    }
    private static native void _execute(long address);

    /**
     * @return WebIDL type: {@link PxBatchQueryPreFilterShader} [Value]
     */
    public PxBatchQueryPreFilterShader getPreFilterShader() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBatchQueryPreFilterShader.wrapPointer(_getPreFilterShader(address));
    }
    private static native long _getPreFilterShader(long address);

    /**
     * @return WebIDL type: {@link PxBatchQueryPostFilterShader} [Value]
     */
    public PxBatchQueryPostFilterShader getPostFilterShader() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBatchQueryPostFilterShader.wrapPointer(_getPostFilterShader(address));
    }
    private static native long _getPostFilterShader(long address);

    /**
     * @return WebIDL type: any [Const]
     */
    public NativeObject getFilterShaderData() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return NativeObject.wrapPointer(_getFilterShaderData(address));
    }
    private static native long _getFilterShaderData(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getFilterShaderDataSize() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getFilterShaderDataSize(address);
    }
    private static native int _getFilterShaderDataSize(long address);

    /**
     * @param userMemory WebIDL type: {@link PxBatchQueryMemory} [Const, Ref]
     */
    public void setUserMemory(PxBatchQueryMemory userMemory) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setUserMemory(address, userMemory.getAddress());
    }
    private static native void _setUserMemory(long address, long userMemory);

    /**
     * @return WebIDL type: {@link PxBatchQueryMemory} [Const, Ref]
     */
    public PxBatchQueryMemory getUserMemory() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBatchQueryMemory.wrapPointer(_getUserMemory(address));
    }
    private static native long _getUserMemory(long address);

    public void release() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _release(address);
    }
    private static native void _release(long address);

}
