package physx.geomutils;

import physx.NativeObject;
import physx.common.PxBase;
import physx.common.PxBounds3;
import physx.common.PxVec3;
import physx.support.PxU32Ptr;

public class PxTriangleMesh extends PxBase {

    protected PxTriangleMesh() { }

    public static PxTriangleMesh wrapPointer(long address) {
        return address != 0L ? new PxTriangleMesh(address) : null;
    }
    
    protected PxTriangleMesh(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbVertices() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getNbVertices(address);
    }
    private static native int _getNbVertices(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Const]
     */
    public PxVec3 getVertices() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_getVertices(address));
    }
    private static native long _getVertices(long address);

    /**
     * @return WebIDL type: {@link PxVec3}
     */
    public PxVec3 getVerticesForModification() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_getVerticesForModification(address));
    }
    private static native long _getVerticesForModification(long address);

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 refitBVH() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBounds3.wrapPointer(_refitBVH(address));
    }
    private static native long _refitBVH(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbTriangles() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getNbTriangles(address);
    }
    private static native int _getNbTriangles(long address);

    /**
     * @return WebIDL type: VoidPtr [Const]
     */
    public NativeObject getTriangles() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return NativeObject.wrapPointer(_getTriangles(address));
    }
    private static native long _getTriangles(long address);

    /**
     * @return WebIDL type: {@link PxTriangleMeshFlags} [Value]
     */
    public PxTriangleMeshFlags getTriangleMeshFlags() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxTriangleMeshFlags.wrapPointer(_getTriangleMeshFlags(address));
    }
    private static native long _getTriangleMeshFlags(long address);

    /**
     * @return WebIDL type: {@link PxU32Ptr} [Const, Value]
     */
    public PxU32Ptr getTrianglesRemap() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxU32Ptr.wrapPointer(_getTrianglesRemap(address));
    }
    private static native long _getTrianglesRemap(long address);

    /**
     * @param triangleIndex WebIDL type: unsigned long
     * @return WebIDL type: unsigned short
     */
    public short getTriangleMaterialIndex(int triangleIndex) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getTriangleMaterialIndex(address, triangleIndex);
    }
    private static native short _getTriangleMaterialIndex(long address, int triangleIndex);

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getLocalBounds() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBounds3.wrapPointer(_getLocalBounds(address));
    }
    private static native long _getLocalBounds(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getReferenceCount() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getReferenceCount(address);
    }
    private static native int _getReferenceCount(long address);

    public void acquireReference() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _acquireReference(address);
    }
    private static native void _acquireReference(long address);

}
