package physx.geomutils;

import physx.NativeObject;
import physx.common.PxBoundedData;

public class PxSimpleTriangleMesh extends NativeObject {

    public static PxSimpleTriangleMesh wrapPointer(long address) {
        return address != 0L ? new PxSimpleTriangleMesh(address) : null;
    }
    
    protected PxSimpleTriangleMesh(long address) {
        super(address);
    }

    // Constructors

    public PxSimpleTriangleMesh() {
        address = _PxSimpleTriangleMesh();
    }
    private static native long _PxSimpleTriangleMesh();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxBoundedData} [Value]
     */
    public PxBoundedData getPoints() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBoundedData.wrapPointer(_getPoints(address));
    }
    private static native long _getPoints(long address);

    /**
     * @param value WebIDL type: {@link PxBoundedData} [Value]
     */
    public void setPoints(PxBoundedData value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setPoints(address, value.getAddress());
    }
    private static native void _setPoints(long address, long value);

    /**
     * @return WebIDL type: {@link PxBoundedData} [Value]
     */
    public PxBoundedData getTriangles() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBoundedData.wrapPointer(_getTriangles(address));
    }
    private static native long _getTriangles(long address);

    /**
     * @param value WebIDL type: {@link PxBoundedData} [Value]
     */
    public void setTriangles(PxBoundedData value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setTriangles(address, value.getAddress());
    }
    private static native void _setTriangles(long address, long value);

    /**
     * @return WebIDL type: {@link PxMeshFlags} [Value]
     */
    public PxMeshFlags getFlags() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxMeshFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxMeshFlags} [Value]
     */
    public void setFlags(PxMeshFlags value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

    // Functions

    public void setToDefault() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
