package physx.geomutils;

import physx.NativeObject;

public class PxHullPolygon extends NativeObject {

    public static PxHullPolygon wrapPointer(long address) {
        return address != 0L ? new PxHullPolygon(address) : null;
    }
    
    protected PxHullPolygon(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxHullPolygon
     */
    public static PxHullPolygon createAt(long address) {
        __placement_new_PxHullPolygon(address);
        PxHullPolygon createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxHullPolygon
     */
    public static <T> PxHullPolygon createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxHullPolygon(address);
        PxHullPolygon createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxHullPolygon(long address);

    // Constructors

    public PxHullPolygon() {
        address = _PxHullPolygon();
    }
    private static native long _PxHullPolygon();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getMPlane(int index) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMPlane(address, index);
    }
    private static native float _getMPlane(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setMPlane(int index, float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMPlane(address, index, value);
    }
    private static native void _setMPlane(long address, int index, float value);

    /**
     * @return WebIDL type: short
     */
    public short getMNbVerts() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMNbVerts(address);
    }
    private static native short _getMNbVerts(long address);

    /**
     * @param value WebIDL type: short
     */
    public void setMNbVerts(short value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMNbVerts(address, value);
    }
    private static native void _setMNbVerts(long address, short value);

    /**
     * @return WebIDL type: short
     */
    public short getMIndexBase() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMIndexBase(address);
    }
    private static native short _getMIndexBase(long address);

    /**
     * @param value WebIDL type: short
     */
    public void setMIndexBase(short value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMIndexBase(address, value);
    }
    private static native void _setMIndexBase(long address, short value);

}
