package physx.geomutils;

import physx.common.PxBase;
import physx.common.PxBounds3;
import physx.common.PxVec3;
import physx.support.PxU8Ptr;

public class PxConvexMesh extends PxBase {

    protected PxConvexMesh() { }

    public static PxConvexMesh wrapPointer(long address) {
        return address != 0L ? new PxConvexMesh(address) : null;
    }
    
    protected PxConvexMesh(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbVertices() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getNbVertices(address);
    }
    private static native int _getNbVertices(long address);

    /**
     * @return WebIDL type: {@link PxVec3} [Const]
     */
    public PxVec3 getVertices() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxVec3.wrapPointer(_getVertices(address));
    }
    private static native long _getVertices(long address);

    /**
     * @return WebIDL type: {@link PxU8Ptr} [Value]
     */
    public PxU8Ptr getIndexBuffer() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxU8Ptr.wrapPointer(_getIndexBuffer(address));
    }
    private static native long _getIndexBuffer(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbPolygons() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getNbPolygons(address);
    }
    private static native int _getNbPolygons(long address);

    /**
     * @param index WebIDL type: unsigned long
     * @param data  WebIDL type: {@link PxHullPolygon} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean getPolygonData(int index, PxHullPolygon data) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getPolygonData(address, index, data.getAddress());
    }
    private static native boolean _getPolygonData(long address, int index, long data);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getReferenceCount() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getReferenceCount(address);
    }
    private static native int _getReferenceCount(long address);

    public void acquireReference() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _acquireReference(address);
    }
    private static native void _acquireReference(long address);

    /**
     * @return WebIDL type: {@link PxBounds3} [Value]
     */
    public PxBounds3 getLocalBounds() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBounds3.wrapPointer(_getLocalBounds(address));
    }
    private static native long _getLocalBounds(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isGpuCompatible() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _isGpuCompatible(address);
    }
    private static native boolean _isGpuCompatible(long address);

}
