package physx.extensions;


public class PxRevoluteJoint extends PxJoint {

    protected PxRevoluteJoint() { }

    public static PxRevoluteJoint wrapPointer(long address) {
        return address != 0L ? new PxRevoluteJoint(address) : null;
    }
    
    protected PxRevoluteJoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param velocity WebIDL type: float
     */
    public void setDriveVelocity(float velocity) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setDriveVelocity(address, velocity);
    }
    private static native void _setDriveVelocity(long address, float velocity);

    /**
     * @param velocity WebIDL type: float
     * @param autowake WebIDL type: boolean
     */
    public void setDriveVelocity(float velocity, boolean autowake) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setDriveVelocity(address, velocity, autowake);
    }
    private static native void _setDriveVelocity(long address, float velocity, boolean autowake);

    /**
     * @return WebIDL type: float
     */
    public float getDriveVelocity() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getDriveVelocity(address);
    }
    private static native float _getDriveVelocity(long address);

    /**
     * @param limit WebIDL type: float
     */
    public void setDriveForceLimit(float limit) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setDriveForceLimit(address, limit);
    }
    private static native void _setDriveForceLimit(long address, float limit);

    /**
     * @return WebIDL type: float
     */
    public float getDriveForceLimit() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getDriveForceLimit(address);
    }
    private static native float _getDriveForceLimit(long address);

    /**
     * @param ratio WebIDL type: float
     */
    public void setDriveGearRatio(float ratio) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setDriveGearRatio(address, ratio);
    }
    private static native void _setDriveGearRatio(long address, float ratio);

    /**
     * @return WebIDL type: float
     */
    public float getDriveGearRatio() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getDriveGearRatio(address);
    }
    private static native float _getDriveGearRatio(long address);

    /**
     * @param flags WebIDL type: {@link PxRevoluteJointFlags} [Ref]
     */
    public void setRevoluteJointFlags(PxRevoluteJointFlags flags) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setRevoluteJointFlags(address, flags.getAddress());
    }
    private static native void _setRevoluteJointFlags(long address, long flags);

    /**
     * @param flag  WebIDL type: {@link PxRevoluteJointFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setRevoluteJointFlag(int flag, boolean value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setRevoluteJointFlag(address, flag, value);
    }
    private static native void _setRevoluteJointFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxRevoluteJointFlags} [Value]
     */
    public PxRevoluteJointFlags getRevoluteJointFlags() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxRevoluteJointFlags.wrapPointer(_getRevoluteJointFlags(address));
    }
    private static native long _getRevoluteJointFlags(long address);

}
