package physx.cooking;

import physx.NativeObject;
import physx.common.PxTolerancesScale;

public class PxCookingParams extends NativeObject {

    protected PxCookingParams() { }

    public static PxCookingParams wrapPointer(long address) {
        return address != 0L ? new PxCookingParams(address) : null;
    }
    
    protected PxCookingParams(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param sc WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     */
    public PxCookingParams(PxTolerancesScale sc) {
        address = _PxCookingParams(sc.getAddress());
    }
    private static native long _PxCookingParams(long sc);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getAreaTestEpsilon() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getAreaTestEpsilon(address);
    }
    private static native float _getAreaTestEpsilon(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setAreaTestEpsilon(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setAreaTestEpsilon(address, value);
    }
    private static native void _setAreaTestEpsilon(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getPlaneTolerance() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getPlaneTolerance(address);
    }
    private static native float _getPlaneTolerance(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setPlaneTolerance(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setPlaneTolerance(address, value);
    }
    private static native void _setPlaneTolerance(long address, float value);

    /**
     * @return WebIDL type: {@link PxConvexMeshCookingTypeEnum} [enum]
     */
    public int getConvexMeshCookingType() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getConvexMeshCookingType(address);
    }
    private static native int _getConvexMeshCookingType(long address);

    /**
     * @param value WebIDL type: {@link PxConvexMeshCookingTypeEnum} [enum]
     */
    public void setConvexMeshCookingType(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setConvexMeshCookingType(address, value);
    }
    private static native void _setConvexMeshCookingType(long address, int value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getSuppressTriangleMeshRemapTable() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getSuppressTriangleMeshRemapTable(address);
    }
    private static native boolean _getSuppressTriangleMeshRemapTable(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setSuppressTriangleMeshRemapTable(boolean value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setSuppressTriangleMeshRemapTable(address, value);
    }
    private static native void _setSuppressTriangleMeshRemapTable(long address, boolean value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getBuildTriangleAdjacencies() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getBuildTriangleAdjacencies(address);
    }
    private static native boolean _getBuildTriangleAdjacencies(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setBuildTriangleAdjacencies(boolean value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setBuildTriangleAdjacencies(address, value);
    }
    private static native void _setBuildTriangleAdjacencies(long address, boolean value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getBuildGPUData() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getBuildGPUData(address);
    }
    private static native boolean _getBuildGPUData(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setBuildGPUData(boolean value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setBuildGPUData(address, value);
    }
    private static native void _setBuildGPUData(long address, boolean value);

    /**
     * @return WebIDL type: {@link PxTolerancesScale} [Value]
     */
    public PxTolerancesScale getScale() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxTolerancesScale.wrapPointer(_getScale(address));
    }
    private static native long _getScale(long address);

    /**
     * @param value WebIDL type: {@link PxTolerancesScale} [Value]
     */
    public void setScale(PxTolerancesScale value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setScale(address, value.getAddress());
    }
    private static native void _setScale(long address, long value);

    /**
     * @return WebIDL type: {@link PxMeshPreprocessingFlags} [Value]
     */
    public PxMeshPreprocessingFlags getMeshPreprocessParams() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxMeshPreprocessingFlags.wrapPointer(_getMeshPreprocessParams(address));
    }
    private static native long _getMeshPreprocessParams(long address);

    /**
     * @param value WebIDL type: {@link PxMeshPreprocessingFlags} [Value]
     */
    public void setMeshPreprocessParams(PxMeshPreprocessingFlags value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMeshPreprocessParams(address, value.getAddress());
    }
    private static native void _setMeshPreprocessParams(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getMeshWeldTolerance() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMeshWeldTolerance(address);
    }
    private static native float _getMeshWeldTolerance(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMeshWeldTolerance(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMeshWeldTolerance(address, value);
    }
    private static native void _setMeshWeldTolerance(long address, float value);

    /**
     * @return WebIDL type: {@link PxMidphaseDesc} [Value]
     */
    public PxMidphaseDesc getMidphaseDesc() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxMidphaseDesc.wrapPointer(_getMidphaseDesc(address));
    }
    private static native long _getMidphaseDesc(long address);

    /**
     * @param value WebIDL type: {@link PxMidphaseDesc} [Value]
     */
    public void setMidphaseDesc(PxMidphaseDesc value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMidphaseDesc(address, value.getAddress());
    }
    private static native void _setMidphaseDesc(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getGaussMapLimit() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getGaussMapLimit(address);
    }
    private static native int _getGaussMapLimit(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setGaussMapLimit(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setGaussMapLimit(address, value);
    }
    private static native void _setGaussMapLimit(long address, int value);

}
