package physx.cooking;

import physx.NativeObject;
import physx.common.PxBoundedData;

public class PxConvexMeshDesc extends NativeObject {

    public static PxConvexMeshDesc wrapPointer(long address) {
        return address != 0L ? new PxConvexMeshDesc(address) : null;
    }
    
    protected PxConvexMeshDesc(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxConvexMeshDesc
     */
    public static PxConvexMeshDesc createAt(long address) {
        __placement_new_PxConvexMeshDesc(address);
        PxConvexMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxConvexMeshDesc
     */
    public static <T> PxConvexMeshDesc createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxConvexMeshDesc(address);
        PxConvexMeshDesc createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxConvexMeshDesc(long address);

    // Constructors

    public PxConvexMeshDesc() {
        address = _PxConvexMeshDesc();
    }
    private static native long _PxConvexMeshDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxBoundedData} [Value]
     */
    public PxBoundedData getPoints() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBoundedData.wrapPointer(_getPoints(address));
    }
    private static native long _getPoints(long address);

    /**
     * @param value WebIDL type: {@link PxBoundedData} [Value]
     */
    public void setPoints(PxBoundedData value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setPoints(address, value.getAddress());
    }
    private static native void _setPoints(long address, long value);

    /**
     * @return WebIDL type: {@link PxConvexFlags} [Value]
     */
    public PxConvexFlags getFlags() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxConvexFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param value WebIDL type: {@link PxConvexFlags} [Value]
     */
    public void setFlags(PxConvexFlags value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setFlags(address, value.getAddress());
    }
    private static native void _setFlags(long address, long value);

}
