package physx.cooking;

import physx.NativeObject;

public class PxBVH33MidphaseDesc extends NativeObject {

    protected PxBVH33MidphaseDesc() { }

    public static PxBVH33MidphaseDesc wrapPointer(long address) {
        return address != 0L ? new PxBVH33MidphaseDesc(address) : null;
    }
    
    protected PxBVH33MidphaseDesc(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMeshSizePerformanceTradeOff() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMeshSizePerformanceTradeOff(address);
    }
    private static native float _getMeshSizePerformanceTradeOff(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMeshSizePerformanceTradeOff(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMeshSizePerformanceTradeOff(address, value);
    }
    private static native void _setMeshSizePerformanceTradeOff(long address, float value);

    /**
     * @return WebIDL type: {@link PxMeshCookingHintEnum} [enum]
     */
    public int getMeshCookingHint() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getMeshCookingHint(address);
    }
    private static native int _getMeshCookingHint(long address);

    /**
     * @param value WebIDL type: {@link PxMeshCookingHintEnum} [enum]
     */
    public void setMeshCookingHint(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setMeshCookingHint(address, value);
    }
    private static native void _setMeshCookingHint(long address, int value);

    // Functions

    public void setToDefault() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
