package physx.common;

import physx.NativeObject;
import physx.support.PxU16Ptr;

public class PxU16StridedData extends NativeObject {

    protected PxU16StridedData() { }

    public static PxU16StridedData wrapPointer(long address) {
        return address != 0L ? new PxU16StridedData(address) : null;
    }
    
    protected PxU16StridedData(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getStride() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getStride(address);
    }
    private static native int _getStride(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setStride(int value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setStride(address, value);
    }
    private static native void _setStride(long address, int value);

    /**
     * @return WebIDL type: {@link PxU16Ptr} [Const, Value]
     */
    public PxU16Ptr getData() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxU16Ptr.wrapPointer(_getData(address));
    }
    private static native long _getData(long address);

    /**
     * @param value WebIDL type: {@link PxU16Ptr} [Const, Value]
     */
    public void setData(PxU16Ptr value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setData(address, value.getAddress());
    }
    private static native void _setData(long address, long value);

}
