package physx.common;

import physx.NativeObject;

public class PxQuat extends NativeObject {

    public static PxQuat wrapPointer(long address) {
        return address != 0L ? new PxQuat(address) : null;
    }
    
    protected PxQuat(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxQuat
     */
    public static PxQuat createAt(long address) {
        __placement_new_PxQuat(address);
        PxQuat createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxQuat
     */
    public static <T> PxQuat createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxQuat(address);
        PxQuat createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxQuat(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param x       WebIDL type: float
     * @param y       WebIDL type: float
     * @param z       WebIDL type: float
     * @param w       WebIDL type: float
     * @return Stack allocated object of PxQuat
     */
    public static PxQuat createAt(long address, float x, float y, float z, float w) {
        __placement_new_PxQuat(address, x, y, z, w);
        PxQuat createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param x         WebIDL type: float
     * @param y         WebIDL type: float
     * @param z         WebIDL type: float
     * @param w         WebIDL type: float
     * @return Stack allocated object of PxQuat
     */
    public static <T> PxQuat createAt(T allocator, Allocator<T> allocate, float x, float y, float z, float w) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxQuat(address, x, y, z, w);
        PxQuat createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxQuat(long address, float x, float y, float z, float w);

    // Constructors

    public PxQuat() {
        address = _PxQuat();
    }
    private static native long _PxQuat();

    /**
     * @param x WebIDL type: float
     * @param y WebIDL type: float
     * @param z WebIDL type: float
     * @param w WebIDL type: float
     */
    public PxQuat(float x, float y, float z, float w) {
        address = _PxQuat(x, y, z, w);
    }
    private static native long _PxQuat(float x, float y, float z, float w);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getX() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getX(address);
    }
    private static native float _getX(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setX(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setX(address, value);
    }
    private static native void _setX(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getY() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getY(address);
    }
    private static native float _getY(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setY(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setY(address, value);
    }
    private static native void _setY(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getZ() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getZ(address);
    }
    private static native float _getZ(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setZ(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setZ(address, value);
    }
    private static native void _setZ(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getW() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getW(address);
    }
    private static native float _getW(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setW(float value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setW(address, value);
    }
    private static native void _setW(long address, float value);

}
