package physx.common;

import physx.NativeObject;

public class PxBase extends NativeObject {

    protected PxBase() { }

    public static PxBase wrapPointer(long address) {
        return address != 0L ? new PxBase(address) : null;
    }
    
    protected PxBase(long address) {
        super(address);
    }

    // Functions

    public void release() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @return WebIDL type: DOMString [Const]
     */
    public String getConcreteTypeName() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getConcreteTypeName(address);
    }
    private static native String _getConcreteTypeName(long address);

    /**
     * @return WebIDL type: long
     */
    public int getConcreteType() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _getConcreteType(address);
    }
    private static native int _getConcreteType(long address);

    /**
     * @param flag  WebIDL type: {@link PxBaseFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setBaseFlag(int flag, boolean value) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setBaseFlag(address, flag, value);
    }
    private static native void _setBaseFlag(long address, int flag, boolean value);

    /**
     * @param inFlags WebIDL type: {@link PxBaseFlags} [Ref]
     */
    public void setBaseFlags(PxBaseFlags inFlags) {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        _setBaseFlags(address, inFlags.getAddress());
    }
    private static native void _setBaseFlags(long address, long inFlags);

    /**
     * @return WebIDL type: {@link PxBaseFlags} [Value]
     */
    public PxBaseFlags getBaseFlags() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return PxBaseFlags.wrapPointer(_getBaseFlags(address));
    }
    private static native long _getBaseFlags(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isReleasable() {
        if (address == 0L) {
            throw new NullPointerException("Native address of " + this + " is 0");
        }
        return _isReleasable(address);
    }
    private static native boolean _isReleasable(long address);

}
