package physx;

import physx.common.PxErrorCallback;
import physx.common.PxFoundation;
import physx.common.PxTolerancesScale;
import physx.common.PxTransform;
import physx.cooking.PxCooking;
import physx.cooking.PxCookingParams;
import physx.extensions.PxDefaultAllocator;
import physx.extensions.PxDefaultCpuDispatcher;
import physx.extensions.PxRevoluteJoint;
import physx.physics.PxBatchQueryPostFilterShader;
import physx.physics.PxBatchQueryPreFilterShader;
import physx.physics.PxPhysics;
import physx.physics.PxRigidActor;
import physx.physics.PxSimulationFilterShader;

public class PxTopLevelFunctions extends NativeObject {

    protected PxTopLevelFunctions() { }

    public static PxTopLevelFunctions wrapPointer(long address) {
        return address != 0L ? new PxTopLevelFunctions(address) : null;
    }
    
    protected PxTopLevelFunctions(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public static int getPHYSICS_VERSION() {
        return _getPHYSICS_VERSION();
    }
    private static native int _getPHYSICS_VERSION();

    // Functions

    /**
     * @return WebIDL type: {@link PxSimulationFilterShader} [Value]
     */
    public static PxSimulationFilterShader DefaultFilterShader() {
        return PxSimulationFilterShader.wrapPointer(_DefaultFilterShader());
    }
    private static native long _DefaultFilterShader();

    /**
     * @return WebIDL type: {@link PxBatchQueryPreFilterShader} [Value]
     */
    public static PxBatchQueryPreFilterShader DefaultWheelSceneQueryPreFilterBlocking() {
        return PxBatchQueryPreFilterShader.wrapPointer(_DefaultWheelSceneQueryPreFilterBlocking());
    }
    private static native long _DefaultWheelSceneQueryPreFilterBlocking();

    /**
     * @return WebIDL type: {@link PxBatchQueryPostFilterShader} [Value]
     */
    public static PxBatchQueryPostFilterShader DefaultWheelSceneQueryPostFilterBlocking() {
        return PxBatchQueryPostFilterShader.wrapPointer(_DefaultWheelSceneQueryPostFilterBlocking());
    }
    private static native long _DefaultWheelSceneQueryPostFilterBlocking();

    /**
     * @param version    WebIDL type: unsigned long
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @param scale      WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @return WebIDL type: {@link PxCooking}
     */
    public static PxCooking CreateCooking(int version, PxFoundation foundation, PxCookingParams scale) {
        return PxCooking.wrapPointer(_CreateCooking(version, foundation.getAddress(), scale.getAddress()));
    }
    private static native long _CreateCooking(int version, long foundation, long scale);

    /**
     * @param version       WebIDL type: unsigned long
     * @param allocator     WebIDL type: {@link PxDefaultAllocator} [Ref]
     * @param errorCallback WebIDL type: {@link PxErrorCallback} [Ref]
     * @return WebIDL type: {@link PxFoundation}
     */
    public static PxFoundation CreateFoundation(int version, PxDefaultAllocator allocator, PxErrorCallback errorCallback) {
        return PxFoundation.wrapPointer(_CreateFoundation(version, allocator.getAddress(), errorCallback.getAddress()));
    }
    private static native long _CreateFoundation(int version, long allocator, long errorCallback);

    /**
     * @param version    WebIDL type: unsigned long
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @param params     WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     * @return WebIDL type: {@link PxPhysics}
     */
    public static PxPhysics CreatePhysics(int version, PxFoundation foundation, PxTolerancesScale params) {
        return PxPhysics.wrapPointer(_CreatePhysics(version, foundation.getAddress(), params.getAddress()));
    }
    private static native long _CreatePhysics(int version, long foundation, long params);

    /**
     * @param numThreads WebIDL type: unsigned long
     * @return WebIDL type: {@link PxDefaultCpuDispatcher}
     */
    public static PxDefaultCpuDispatcher DefaultCpuDispatcherCreate(int numThreads) {
        return PxDefaultCpuDispatcher.wrapPointer(_DefaultCpuDispatcherCreate(numThreads));
    }
    private static native long _DefaultCpuDispatcherCreate(int numThreads);

    /**
     * @param physics WebIDL type: {@link PxPhysics} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean InitExtensions(PxPhysics physics) {
        return _InitExtensions(physics.getAddress());
    }
    private static native boolean _InitExtensions(long physics);

    /**
     * @param physics     WebIDL type: {@link PxPhysics} [Ref]
     * @param actor0      WebIDL type: {@link PxRigidActor}
     * @param localFrame0 WebIDL type: {@link PxTransform} [Ref]
     * @param actor1      WebIDL type: {@link PxRigidActor}
     * @param localFrame1 WebIDL type: {@link PxTransform} [Ref]
     * @return WebIDL type: {@link PxRevoluteJoint}
     */
    public static PxRevoluteJoint RevoluteJointCreate(PxPhysics physics, PxRigidActor actor0, PxTransform localFrame0, PxRigidActor actor1, PxTransform localFrame1) {
        return PxRevoluteJoint.wrapPointer(_RevoluteJointCreate(physics.getAddress(), actor0.getAddress(), localFrame0.getAddress(), actor1.getAddress(), localFrame1.getAddress()));
    }
    private static native long _RevoluteJointCreate(long physics, long actor0, long localFrame0, long actor1, long localFrame1);

}
