package physx;


public class NativeObject {

    static {
        de.fabmax.physxjni.Loader.load();
    }

    protected NativeObject() { }

    protected long address = 0L;
    protected boolean isExternallyAllocated = false;
    
    protected NativeObject(long address) {
        this.address = address;
    }
    
    public static NativeObject wrapPointer(long address) {
        return new NativeObject(address);
    }
    
    public long getAddress() {
        return address;
    }
    
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof NativeObject)) return false;
        NativeObject that = (NativeObject) o;
        return address == that.address;
    }
    
    @Override
    public int hashCode() {
        return (int) (address ^ (address >>> 32));
    }
    
    @FunctionalInterface
    public interface Allocator<T> {
        long on(T allocator, int alignment, int size);
    }
}
