package physx.vehicle;

import physx.NativeObject;

public class PxVehicleWheelsSimFlags extends NativeObject {

    protected PxVehicleWheelsSimFlags() { }

    public static PxVehicleWheelsSimFlags wrapPointer(long address) {
        return new PxVehicleWheelsSimFlags(address);
    }
    
    protected PxVehicleWheelsSimFlags(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: unsigned long
     * @return Stack allocated object of PxVehicleWheelsSimFlags
     */
    public static PxVehicleWheelsSimFlags createAt(long address, int flags) {
        __placement_new_PxVehicleWheelsSimFlags(address, flags);
        PxVehicleWheelsSimFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: unsigned long
     * @return Stack allocated object of PxVehicleWheelsSimFlags
     */
    public static <T> PxVehicleWheelsSimFlags createAt(T allocator, Allocator<T> allocate, int flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleWheelsSimFlags(address, flags);
        PxVehicleWheelsSimFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleWheelsSimFlags(long address, int flags);

    // Constructors

    /**
     * @param flags WebIDL type: unsigned long
     */
    public PxVehicleWheelsSimFlags(int flags) {
        address = _PxVehicleWheelsSimFlags(flags);
    }
    private static native long _PxVehicleWheelsSimFlags(int flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxVehicleWheelsSimFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(int flag) {
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxVehicleWheelsSimFlagEnum} [enum]
     */
    public void set(int flag) {
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxVehicleWheelsSimFlagEnum} [enum]
     */
    public void clear(int flag) {
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
