package physx.vehicle;

import physx.NativeObject;

public class PxVehicleWheelQueryResult extends NativeObject {

    public static PxVehicleWheelQueryResult wrapPointer(long address) {
        return new PxVehicleWheelQueryResult(address);
    }
    
    protected PxVehicleWheelQueryResult(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleWheelQueryResult() {
        address = _PxVehicleWheelQueryResult();
    }
    private static native long _PxVehicleWheelQueryResult();

    // Attributes

    /**
     * @return WebIDL type: {@link PxWheelQueryResult}
     */
    public PxWheelQueryResult getWheelQueryResults() {
        return PxWheelQueryResult.wrapPointer(_getWheelQueryResults(address));
    }
    private static native long _getWheelQueryResults(long address);

    /**
     * @param value WebIDL type: {@link PxWheelQueryResult}
     */
    public void setWheelQueryResults(PxWheelQueryResult value) {
        _setWheelQueryResults(address, value.getAddress());
    }
    private static native void _setWheelQueryResults(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelQueryResults() {
        return _getNbWheelQueryResults(address);
    }
    private static native int _getNbWheelQueryResults(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbWheelQueryResults(int value) {
        _setNbWheelQueryResults(address, value);
    }
    private static native void _setNbWheelQueryResults(long address, int value);

}
