package physx.vehicle;

import physx.NativeObject;

public class PxVehicleWheelData extends NativeObject {

    public static PxVehicleWheelData wrapPointer(long address) {
        return new PxVehicleWheelData(address);
    }
    
    protected PxVehicleWheelData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleWheelData() {
        address = _PxVehicleWheelData();
    }
    private static native long _PxVehicleWheelData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMRadius() {
        return _getMRadius(address);
    }
    private static native float _getMRadius(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMRadius(float value) {
        _setMRadius(address, value);
    }
    private static native void _setMRadius(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMWidth() {
        return _getMWidth(address);
    }
    private static native float _getMWidth(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMWidth(float value) {
        _setMWidth(address, value);
    }
    private static native void _setMWidth(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMass() {
        return _getMMass(address);
    }
    private static native float _getMMass(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMass(float value) {
        _setMMass(address, value);
    }
    private static native void _setMMass(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMOI() {
        return _getMMOI(address);
    }
    private static native float _getMMOI(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMOI(float value) {
        _setMMOI(address, value);
    }
    private static native void _setMMOI(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMDampingRate() {
        return _getMDampingRate(address);
    }
    private static native float _getMDampingRate(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMDampingRate(float value) {
        _setMDampingRate(address, value);
    }
    private static native void _setMDampingRate(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxBrakeTorque() {
        return _getMMaxBrakeTorque(address);
    }
    private static native float _getMMaxBrakeTorque(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxBrakeTorque(float value) {
        _setMMaxBrakeTorque(address, value);
    }
    private static native void _setMMaxBrakeTorque(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxHandBrakeTorque() {
        return _getMMaxHandBrakeTorque(address);
    }
    private static native float _getMMaxHandBrakeTorque(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxHandBrakeTorque(float value) {
        _setMMaxHandBrakeTorque(address, value);
    }
    private static native void _setMMaxHandBrakeTorque(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxSteer() {
        return _getMMaxSteer(address);
    }
    private static native float _getMMaxSteer(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxSteer(float value) {
        _setMMaxSteer(address, value);
    }
    private static native void _setMMaxSteer(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMToeAngle() {
        return _getMToeAngle(address);
    }
    private static native float _getMToeAngle(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMToeAngle(float value) {
        _setMToeAngle(address, value);
    }
    private static native void _setMToeAngle(long address, float value);

}
