package physx.vehicle;

import physx.NativeObject;

public class PxVehicleSuspensionData extends NativeObject {

    public static PxVehicleSuspensionData wrapPointer(long address) {
        return new PxVehicleSuspensionData(address);
    }
    
    protected PxVehicleSuspensionData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSuspensionData() {
        address = _PxVehicleSuspensionData();
    }
    private static native long _PxVehicleSuspensionData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMSpringStrength() {
        return _getMSpringStrength(address);
    }
    private static native float _getMSpringStrength(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMSpringStrength(float value) {
        _setMSpringStrength(address, value);
    }
    private static native void _setMSpringStrength(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMSpringDamperRate() {
        return _getMSpringDamperRate(address);
    }
    private static native float _getMSpringDamperRate(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMSpringDamperRate(float value) {
        _setMSpringDamperRate(address, value);
    }
    private static native void _setMSpringDamperRate(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxCompression() {
        return _getMMaxCompression(address);
    }
    private static native float _getMMaxCompression(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxCompression(float value) {
        _setMMaxCompression(address, value);
    }
    private static native void _setMMaxCompression(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxDroop() {
        return _getMMaxDroop(address);
    }
    private static native float _getMMaxDroop(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxDroop(float value) {
        _setMMaxDroop(address, value);
    }
    private static native void _setMMaxDroop(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMSprungMass() {
        return _getMSprungMass(address);
    }
    private static native float _getMSprungMass(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMSprungMass(float value) {
        _setMSprungMass(address, value);
    }
    private static native void _setMSprungMass(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMCamberAtRest() {
        return _getMCamberAtRest(address);
    }
    private static native float _getMCamberAtRest(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMCamberAtRest(float value) {
        _setMCamberAtRest(address, value);
    }
    private static native void _setMCamberAtRest(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMCamberAtMaxCompression() {
        return _getMCamberAtMaxCompression(address);
    }
    private static native float _getMCamberAtMaxCompression(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMCamberAtMaxCompression(float value) {
        _setMCamberAtMaxCompression(address, value);
    }
    private static native void _setMCamberAtMaxCompression(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMCamberAtMaxDroop() {
        return _getMCamberAtMaxDroop(address);
    }
    private static native float _getMCamberAtMaxDroop(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMCamberAtMaxDroop(float value) {
        _setMCamberAtMaxDroop(address, value);
    }
    private static native void _setMCamberAtMaxDroop(long address, float value);

    // Functions

    /**
     * @param newSprungMass WebIDL type: float
     */
    public void setMassAndPreserveNaturalFrequency(float newSprungMass) {
        _setMassAndPreserveNaturalFrequency(address, newSprungMass);
    }
    private static native void _setMassAndPreserveNaturalFrequency(long address, float newSprungMass);

}
