package physx.vehicle;

import physx.NativeObject;

public class PxVehicleDriveSimData extends NativeObject {

    public static PxVehicleDriveSimData wrapPointer(long address) {
        return new PxVehicleDriveSimData(address);
    }
    
    protected PxVehicleDriveSimData(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleDriveSimData() {
        address = _PxVehicleDriveSimData();
    }
    private static native long _PxVehicleDriveSimData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: {@link PxVehicleEngineData} [Const, Ref]
     */
    public PxVehicleEngineData getEngineData() {
        return PxVehicleEngineData.wrapPointer(_getEngineData(address));
    }
    private static native long _getEngineData(long address);

    /**
     * @param engine WebIDL type: {@link PxVehicleEngineData} [Const, Ref]
     */
    public void setEngineData(PxVehicleEngineData engine) {
        _setEngineData(address, engine.getAddress());
    }
    private static native void _setEngineData(long address, long engine);

    /**
     * @return WebIDL type: {@link PxVehicleGearsData} [Const, Ref]
     */
    public PxVehicleGearsData getGearsData() {
        return PxVehicleGearsData.wrapPointer(_getGearsData(address));
    }
    private static native long _getGearsData(long address);

    /**
     * @param gears WebIDL type: {@link PxVehicleGearsData} [Const, Ref]
     */
    public void setGearsData(PxVehicleGearsData gears) {
        _setGearsData(address, gears.getAddress());
    }
    private static native void _setGearsData(long address, long gears);

    /**
     * @return WebIDL type: {@link PxVehicleClutchData} [Const, Ref]
     */
    public PxVehicleClutchData getClutchData() {
        return PxVehicleClutchData.wrapPointer(_getClutchData(address));
    }
    private static native long _getClutchData(long address);

    /**
     * @param clutch WebIDL type: {@link PxVehicleClutchData} [Const, Ref]
     */
    public void setClutchData(PxVehicleClutchData clutch) {
        _setClutchData(address, clutch.getAddress());
    }
    private static native void _setClutchData(long address, long clutch);

    /**
     * @return WebIDL type: {@link PxVehicleAutoBoxData} [Const, Ref]
     */
    public PxVehicleAutoBoxData getAutoBoxData() {
        return PxVehicleAutoBoxData.wrapPointer(_getAutoBoxData(address));
    }
    private static native long _getAutoBoxData(long address);

    /**
     * @param clutch WebIDL type: {@link PxVehicleAutoBoxData} [Const, Ref]
     */
    public void setAutoBoxData(PxVehicleAutoBoxData clutch) {
        _setAutoBoxData(address, clutch.getAddress());
    }
    private static native void _setAutoBoxData(long address, long clutch);

}
