package physx.vehicle;


public class PxVehicleDrive extends PxVehicleWheels {

    protected PxVehicleDrive() { }

    public static PxVehicleDrive wrapPointer(long address) {
        return new PxVehicleDrive(address);
    }
    
    protected PxVehicleDrive(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleDriveDynData} [Value]
     */
    public PxVehicleDriveDynData getMDriveDynData() {
        return PxVehicleDriveDynData.wrapPointer(_getMDriveDynData(address));
    }
    private static native long _getMDriveDynData(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDriveDynData} [Value]
     */
    public void setMDriveDynData(PxVehicleDriveDynData value) {
        _setMDriveDynData(address, value.getAddress());
    }
    private static native void _setMDriveDynData(long address, long value);

}
